/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.EjectionRecoveryMenu;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class EjectionRecoveryScreen
extends EasyMenuScreen<EjectionRecoveryMenu> {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.vanillaResource("textures/gui/container/generic_54.png");
    EasyButton buttonLeft;
    EasyButton buttonRight;
    EasyButton buttonSplit;

    public EjectionRecoveryScreen(EjectionRecoveryMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.resize(176, 222);
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.buttonLeft = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(-20, 0))).pressAction(() -> this.changeSelection(-1))).icon(IconUtil.ICON_LEFT).addon(EasyAddonHelper.activeCheck(() -> ((EjectionRecoveryMenu)this.f_97732_).getSelectedIndex() > 0))).build());
        this.buttonRight = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width, 0))).pressAction(() -> this.changeSelection(1))).icon(IconUtil.ICON_RIGHT).addon(EasyAddonHelper.activeCheck(() -> ((EjectionRecoveryMenu)this.f_97732_).getSelectedIndex() < ((EjectionRecoveryMenu)this.f_97732_).getValidEjectionData().size() - 1))).build());
        this.buttonSplit = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(-20, 20))).pressAction(this::splitData)).icon(this::getSplitIcon).addon(EasyAddonHelper.visibleCheck(this::canSplit))).addon(EasyAddonHelper.tooltips(this::getSplitTooltip))).build());
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.renderNormalBackground(GUI_TEXTURE, this);
        gui.drawString(this.getTraderTitle(), this.f_97728_, this.f_97729_, 0x404040);
        gui.drawString(this.f_169604_, this.f_97730_, this.f_97727_ - 94, 0x404040);
    }

    private Component getTraderTitle() {
        EjectionData data = ((EjectionRecoveryMenu)this.f_97732_).getSelectedData();
        if (data != null) {
            return data.getName();
        }
        return LCText.GUI_EJECTION_NO_DATA.get(new Object[0]);
    }

    private void changeSelection(int delta) {
        int newSelection = ((EjectionRecoveryMenu)this.f_97732_).getSelectedIndex() + delta;
        ((EjectionRecoveryMenu)this.f_97732_).changeSelection(newSelection);
    }

    private boolean canSplit() {
        EjectionData data = ((EjectionRecoveryMenu)this.f_97732_).getSelectedData();
        return data != null && data.canSplit();
    }

    private IconData getSplitIcon() {
        EjectionData data = ((EjectionRecoveryMenu)this.f_97732_).getSelectedData();
        return data != null ? data.getSplitButtonIcon() : IconUtil.ICON_X;
    }

    private List<Component> getSplitTooltip() {
        EjectionData data = ((EjectionRecoveryMenu)this.f_97732_).getSelectedData();
        return data != null ? data.getSplitButtonTooltip() : new ArrayList<Component>();
    }

    private void splitData(EasyButton button) {
        ((EjectionRecoveryMenu)this.f_97732_).splitSelectedData();
    }
}

