/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.easy.tabbed;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.tabbed.EasyClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.util.IWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.ITab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.TabButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class EasyClientTabbedMenuScreen<M extends AbstractContainerMenu, S extends EasyClientTabbedMenuScreen<M, S, T>, T extends EasyClientTab<M, S, T>>
extends EasyMenuScreen<M> {
    private boolean tabsLocked = false;
    private int currentTabIndex = -1;
    private int currentAddIndex = 0;
    private Map<Integer, T> menuTabs = null;
    private IWidgetPositioner tabButtonPositioner;

    @Nonnull
    public final T currentTab() {
        return (T)((EasyClientTab)this.menuTabs.get(this.currentTabIndex));
    }

    public final Map<Integer, T> getAllTabs() {
        return this.menuTabs == null ? ImmutableMap.of() : ImmutableMap.copyOf(this.menuTabs);
    }

    protected EasyClientTabbedMenuScreen(M menu, Inventory inventory) {
        super(menu, inventory);
    }

    protected EasyClientTabbedMenuScreen(M menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    protected final void initializeTabs() {
        if (this.tabsLocked) {
            throw new IllegalStateException("Cannot initialize the menus tabs when they've already be initialized!");
        }
        this.menuTabs = new HashMap<Integer, T>();
        this.registerTabs();
        if (!this.menuTabs.containsKey(0)) {
            throw new IllegalArgumentException("EasyClientTabbedMenuScreen#registerTabs did not register a tab for key 0!");
        }
        this.tabsLocked = true;
        this.ChangeTab(0);
    }

    @Override
    protected final void initialize(ScreenArea screenArea) {
        this.init(screenArea);
        this.tabButtonPositioner = this.getTabButtonPositioner();
        this.tabButtonPositioner.clear();
        this.addChild(this.tabButtonPositioner);
        this.menuTabs.forEach((key, tab) -> {
            TabButton button = ((TabButton.Builder)((TabButton.Builder)((TabButton.Builder)TabButton.builder().pressAction(() -> this.ChangeTab((int)key))).tab((ITab)tab).addon(EasyAddonHelper.activeCheck(() -> this.currentTabIndex != key))).addon(EasyAddonHelper.visibleCheck(tab::tabVisible))).build();
            this.addChild(button);
            this.tabButtonPositioner.addWidget(button);
        });
        ((EasyTab)this.currentTab()).onOpen();
    }

    @Nonnull
    protected abstract IWidgetPositioner getTabButtonPositioner();

    protected abstract void init(ScreenArea var1);

    protected abstract void registerTabs();

    public final void addTab(@Nonnull T tab) {
        if (this.tabsLocked || this.menuTabs == null) {
            this.setTab(this.currentAddIndex, tab);
        } else {
            this.setTab(this.currentAddIndex++, tab);
        }
    }

    public final void setTab(int key, @Nonnull T tab) {
        if (this.tabsLocked) {
            LightmansCurrency.LogError("Attempted to define a tab for the menu after the registration has been locked!");
            return;
        }
        if (this.menuTabs == null) {
            LightmansCurrency.LogError("Attempted to register a tab for the menu outside of the #registerTabs function!");
            return;
        }
        this.menuTabs.put(key, tab);
    }

    public final void clearTab(int key) {
        if (this.tabsLocked) {
            LightmansCurrency.LogError("Attempted to clear a tab for the menu after the registration has been locked!");
            return;
        }
        if (this.menuTabs == null) {
            LightmansCurrency.LogError("Attempted to clear a tab for the menu outside of the #registerTabs function!");
            return;
        }
        if (key == 0) {
            LightmansCurrency.LogError("Attempted to clear the tab for the root key!");
            return;
        }
        this.menuTabs.remove(key);
    }

    private void ChangeTab(int newTab) {
        if (newTab == this.currentTabIndex) {
            return;
        }
        if (!this.menuTabs.containsKey(newTab)) {
            LightmansCurrency.LogError("Attempted to open tab " + newTab + ", but no tab with that key is present in the menu!");
            return;
        }
        if (this.currentTab() != null) {
            ((EasyTab)this.currentTab()).onClose();
        }
        this.currentTabIndex = newTab;
        ((EasyTab)this.currentTab()).onOpen();
    }

    @Override
    protected final void renderBG(@Nonnull EasyGuiGraphics gui) {
        this.renderBackground(gui);
        ((EasyTab)this.currentTab()).renderBG(gui);
    }

    protected abstract void renderBackground(@Nonnull EasyGuiGraphics var1);

    @Override
    protected final void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        this.renderLate(gui);
        ((EasyTab)this.currentTab()).renderAfterWidgets(gui);
    }

    protected void renderLate(@Nonnull EasyGuiGraphics gui) {
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.currentTab() != null && ((EasyTab)this.currentTab()).blockInventoryClosing();
    }

    @Override
    @Nullable
    public Pair<ItemStack, ScreenArea> getHoveredItem(@Nonnull ScreenPosition mousePos) {
        return ((EasyClientTab)this.currentTab()).getHoveredItem(mousePos);
    }

    @Override
    @Nullable
    public Pair<FluidStack, ScreenArea> getHoveredFluid(@Nonnull ScreenPosition mousePos) {
        return ((EasyClientTab)this.currentTab()).getHoveredFluid(mousePos);
    }
}

