/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.upgrades;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public final class UpgradeData {
    public static final UpgradeData EMPTY = new UpgradeData();
    private final Map<String, Boolean> boolData;
    private final Map<String, Long> intData;
    private final Map<String, Double> floatData;
    private final Map<String, String> stringData;
    private final Map<String, CompoundTag> tagData;

    private UpgradeData() {
        this.boolData = ImmutableMap.of();
        this.intData = ImmutableMap.of();
        this.floatData = ImmutableMap.of();
        this.stringData = ImmutableMap.of();
        this.tagData = ImmutableMap.of();
    }

    private UpgradeData(@Nonnull Map<String, Boolean> boolData, @Nonnull Map<String, Long> intData, @Nonnull Map<String, Double> floatData, @Nonnull Map<String, String> stringData, @Nonnull Map<String, CompoundTag> tagData) {
        this.boolData = ImmutableMap.copyOf(boolData);
        this.intData = ImmutableMap.copyOf(intData);
        this.floatData = ImmutableMap.copyOf(floatData);
        this.stringData = ImmutableMap.copyOf(stringData);
        this.tagData = ImmutableMap.copyOf(tagData);
    }

    public boolean isEmpty() {
        return this.boolData.isEmpty() && this.intData.isEmpty() && this.floatData.isEmpty() && this.stringData.isEmpty() && this.tagData.isEmpty();
    }

    public boolean hasBoolValue(@Nonnull String tag) {
        return this.boolData.containsKey(tag);
    }

    public boolean hasIntValue(@Nonnull String tag) {
        return this.intData.containsKey(tag);
    }

    public boolean hasLongValue(@Nonnull String tag) {
        return this.intData.containsKey(tag);
    }

    public boolean hasFloatValue(@Nonnull String tag) {
        return this.floatData.containsKey(tag);
    }

    public boolean hasDoubleValue(@Nonnull String tag) {
        return this.floatData.containsKey(tag);
    }

    public boolean hasStringValue(@Nonnull String tag) {
        return this.stringData.containsKey(tag);
    }

    public boolean hasCompoundValue(@Nonnull String tag) {
        return this.tagData.containsKey(tag);
    }

    public boolean getBooleanValue(@Nonnull String tag) {
        return this.boolData.getOrDefault(tag, false);
    }

    public int getIntValue(@Nonnull String tag) {
        return this.intData.getOrDefault(tag, 0L).intValue();
    }

    public long getLongValue(@Nonnull String tag) {
        return this.intData.getOrDefault(tag, 0L);
    }

    public float getFloatValue(@Nonnull String tag) {
        return this.floatData.getOrDefault(tag, 0.0).floatValue();
    }

    public double getDoubleValue(@Nonnull String tag) {
        return this.floatData.getOrDefault(tag, 0.0);
    }

    @Nonnull
    public String getStringValue(@Nonnull String tag) {
        return this.stringData.getOrDefault(tag, "");
    }

    @Nonnull
    public CompoundTag getCompoundValue(@Nonnull String tag) {
        return this.tagData.getOrDefault(tag, new CompoundTag());
    }

    @Nonnull
    public Mutable makeMutable() {
        return new Mutable(this.boolData, this.intData, this.floatData, this.stringData, UpgradeData.copyTags(this.tagData));
    }

    public boolean equals(Object obj) {
        if (obj instanceof UpgradeData) {
            UpgradeData other = (UpgradeData)obj;
            return this.boolData.equals(other.boolData) && this.intData.equals(other.intData) && this.floatData.equals(other.floatData) && this.stringData.equals(other.stringData) && this.tagData.equals(other.tagData);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.boolData, this.intData, this.floatData, this.stringData, this.tagData);
    }

    @Nonnull
    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        if (!this.boolData.isEmpty()) {
            tag.m_128365_("booleans", (Tag)UpgradeData.writeMap(this.boolData, (b, t) -> t.m_128379_("value", b.booleanValue())));
        }
        if (!this.intData.isEmpty()) {
            tag.m_128365_("integers", (Tag)UpgradeData.writeMap(this.intData, (i, t) -> t.m_128356_("value", i.longValue())));
        }
        if (!this.floatData.isEmpty()) {
            tag.m_128365_("floats", (Tag)UpgradeData.writeMap(this.floatData, (f, t) -> t.m_128347_("value", f.doubleValue())));
        }
        if (!this.stringData.isEmpty()) {
            tag.m_128365_("strings", (Tag)UpgradeData.writeMap(this.stringData, (s, t) -> t.m_128359_("value", s)));
        }
        if (!this.tagData.isEmpty()) {
            tag.m_128365_("compounds", (Tag)UpgradeData.writeMap(this.tagData, (v, t) -> t.m_128365_("value", (Tag)v)));
        }
        return tag;
    }

    @Nonnull
    public static <T> ListTag writeMap(@Nonnull Map<String, T> map, @Nonnull BiConsumer<T, CompoundTag> valueWriter) {
        ListTag list = new ListTag();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("key", entry.getKey());
            valueWriter.accept(entry.getValue(), tag);
            list.add((Object)tag);
        }
        return list;
    }

    @Nonnull
    public static UpgradeData parse(@Nonnull CompoundTag tag) {
        HashMap<String, Boolean> boolData = new HashMap<String, Boolean>();
        HashMap<String, Long> intData = new HashMap<String, Long>();
        HashMap<String, Double> floatData = new HashMap<String, Double>();
        HashMap<String, String> stringData = new HashMap<String, String>();
        HashMap<String, CompoundTag> tagData = new HashMap<String, CompoundTag>();
        if (tag.m_128425_("booleans", 9)) {
            UpgradeData.readMap(boolData, tag.m_128437_("booleans", 10), t -> t.m_128471_("value"));
        }
        if (tag.m_128425_("integers", 9)) {
            UpgradeData.readMap(intData, tag.m_128437_("integers", 10), t -> t.m_128454_("value"));
        }
        if (tag.m_128425_("floats", 9)) {
            UpgradeData.readMap(floatData, tag.m_128437_("floats", 10), t -> t.m_128459_("value"));
        }
        if (tag.m_128425_("strings", 9)) {
            UpgradeData.readMap(stringData, tag.m_128437_("strings", 10), t -> t.m_128461_("value"));
        }
        if (tag.m_128425_("compounds", 9)) {
            UpgradeData.readMap(tagData, tag.m_128437_("compounds", 10), t -> t.m_128469_("value"));
        }
        return new UpgradeData(boolData, intData, floatData, stringData, tagData);
    }

    public static <T> void readMap(@Nonnull Map<String, T> map, @Nonnull ListTag list, @Nonnull Function<CompoundTag, T> valueReader) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            String key = tag.m_128461_("key");
            T value = valueReader.apply(tag);
            map.put(key, value);
        }
    }

    private static Map<String, CompoundTag> copyTags(Map<String, CompoundTag> original) {
        HashMap<String, CompoundTag> copy = new HashMap<String, CompoundTag>();
        original.forEach((key, tag) -> copy.put((String)key, tag.m_6426_()));
        return copy;
    }

    public static final class Mutable {
        private final Map<String, Boolean> boolData;
        private final Map<String, Long> intData;
        private final Map<String, Double> floatData;
        private final Map<String, String> stringData;
        private final Map<String, CompoundTag> tagData;

        private Mutable(@Nonnull Map<String, Boolean> boolData, @Nonnull Map<String, Long> intData, @Nonnull Map<String, Double> floatData, @Nonnull Map<String, String> stringData, @Nonnull Map<String, CompoundTag> tagData) {
            this.boolData = new HashMap<String, Boolean>(boolData);
            this.intData = new HashMap<String, Long>(intData);
            this.floatData = new HashMap<String, Double>(floatData);
            this.stringData = new HashMap<String, String>(stringData);
            this.tagData = new HashMap<String, CompoundTag>(tagData);
        }

        public boolean hasBoolValue(@Nonnull String tag) {
            return this.boolData.containsKey(tag);
        }

        public boolean hasIntValue(@Nonnull String tag) {
            return this.intData.containsKey(tag);
        }

        public boolean hasLongValue(@Nonnull String tag) {
            return this.intData.containsKey(tag);
        }

        public boolean hasFloatValue(@Nonnull String tag) {
            return this.floatData.containsKey(tag);
        }

        public boolean hasDoubleValue(@Nonnull String tag) {
            return this.floatData.containsKey(tag);
        }

        public boolean hasStringValue(@Nonnull String tag) {
            return this.stringData.containsKey(tag);
        }

        public boolean hasCompoundValue(@Nonnull String tag) {
            return this.tagData.containsKey(tag);
        }

        public boolean getBooleanValue(@Nonnull String tag) {
            return this.boolData.getOrDefault(tag, false);
        }

        public int getIntValue(@Nonnull String tag) {
            return this.intData.getOrDefault(tag, 0L).intValue();
        }

        public long getLongValue(@Nonnull String tag) {
            return this.intData.getOrDefault(tag, 0L);
        }

        public float getFloatValue(@Nonnull String tag) {
            return this.floatData.getOrDefault(tag, 0.0).floatValue();
        }

        public double getDoubleValue(@Nonnull String tag) {
            return this.floatData.getOrDefault(tag, 0.0);
        }

        @Nonnull
        public String getStringValue(@Nonnull String tag) {
            return this.stringData.getOrDefault(tag, "");
        }

        @Nonnull
        public CompoundTag getCompoundValue(@Nonnull String tag) {
            return this.tagData.getOrDefault(tag, new CompoundTag());
        }

        public void setBooleanValue(@Nonnull String tag, boolean value) {
            this.boolData.put(tag, value);
        }

        public void setIntValue(@Nonnull String tag, int value) {
            this.intData.put(tag, Long.valueOf(value));
        }

        public void setLongValue(@Nonnull String tag, long value) {
            this.intData.put(tag, value);
        }

        public void setFloatValue(@Nonnull String tag, float value) {
            this.floatData.put(tag, Double.valueOf(value));
        }

        public void setDoubleValue(@Nonnull String tag, double value) {
            this.floatData.put(tag, value);
        }

        public void setStringValue(@Nonnull String tag, @Nonnull String value) {
            this.stringData.put(tag, value);
        }

        public void setCompoundValue(@Nonnull String tag, @Nonnull CompoundTag value) {
            this.tagData.put(tag, value.m_6426_());
        }

        public void merge(@Nonnull UpgradeData data) {
            data.boolData.forEach(this::setBooleanValue);
            data.intData.forEach(this::setLongValue);
            data.floatData.forEach(this::setDoubleValue);
            data.stringData.forEach(this::setStringValue);
            data.tagData.forEach(this::setCompoundValue);
        }

        @Nonnull
        public UpgradeData makeImmutable() {
            return new UpgradeData(this.boolData, this.intData, this.floatData, this.stringData, UpgradeData.copyTags(this.tagData));
        }
    }
}

