/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.rules.data;

import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class PlayerMemory {
    private final Map<UUID, List<Long>> memory = new HashMap<UUID, List<Long>>();

    public int getCount(TradeEvent event, long timeLimit) {
        return this.getCount(event.getContext().getPlayerReference().id, timeLimit);
    }

    public int getCount(UUID player, long timeLimit) {
        int count = 0;
        if (this.memory.containsKey(player)) {
            List<Long> eventTimes = this.memory.get(player);
            if (timeLimit <= 0L) {
                return eventTimes.size();
            }
            for (Long eventTime : eventTimes) {
                if (!TimeUtil.compareTime(timeLimit, eventTime)) continue;
                ++count;
            }
        }
        return count;
    }

    public void addEntry(UUID player) {
        List list = this.memory.getOrDefault(player, new ArrayList());
        list.add(TimeUtil.getCurrentTime());
        this.memory.put(player, list);
    }

    public void clear() {
        this.memory.clear();
    }

    public boolean clearExpiredData(long timeLimit) {
        if (timeLimit <= 0L) {
            return false;
        }
        AtomicBoolean changed = new AtomicBoolean(false);
        ArrayList emptyEntries = new ArrayList();
        this.memory.forEach((id, eventTimes) -> {
            for (int i = 0; i < eventTimes.size(); ++i) {
                if (TimeUtil.compareTime(timeLimit, (Long)eventTimes.get(i))) continue;
                eventTimes.remove(i);
                --i;
                changed.set(true);
            }
            if (eventTimes.isEmpty()) {
                emptyEntries.add(id);
            }
        });
        emptyEntries.forEach(this.memory::remove);
        return changed.get();
    }

    public void save(CompoundTag compound) {
        ListTag memoryList = new ListTag();
        this.memory.forEach((id, entries) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("ID", id);
            tag.m_128428_("Times", entries);
            memoryList.add((Object)tag);
        });
        compound.m_128365_("Memory", (Tag)memoryList);
    }

    public void load(CompoundTag compound) {
        if (compound.m_128425_("Memory", 9)) {
            this.memory.clear();
            ListTag memoryList = compound.m_128437_("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                CompoundTag tag = memoryList.m_128728_(i);
                if (!tag.m_128441_("ID")) continue;
                ArrayList<Long> eventTimes = new ArrayList<Long>();
                for (long time : tag.m_128467_("Times")) {
                    eventTimes.add(time);
                }
                this.memory.put(tag.m_128342_("ID"), eventTimes);
            }
        }
    }
}

