/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.taxes.notifications;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TaxEntryCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.NonNullSupplier;

public class TaxesCollectedNotification
extends SingleLineNotification {
    public static final NotificationType<TaxesCollectedNotification> TYPE = new NotificationType(VersionUtil.lcResource("taxes_collected"), TaxesCollectedNotification::new);
    private MutableComponent taxedName = EasyText.literal("NULL");
    private MoneyValue amount = MoneyValue.empty();
    private TaxEntryCategory category;

    private TaxesCollectedNotification() {
    }

    private TaxesCollectedNotification(MutableComponent taxedName, MoneyValue amount, TaxEntryCategory category) {
        this.taxedName = taxedName;
        this.amount = amount;
        this.category = category;
    }

    public static NonNullSupplier<Notification> create(MutableComponent taxedName, MoneyValue amount, TaxEntryCategory category) {
        return () -> new TaxesCollectedNotification(taxedName, amount, category);
    }

    @Nonnull
    protected NotificationType<TaxesCollectedNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return this.category;
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        return LCText.NOTIFICATION_TAXES_COLLECTED.get(this.amount.getText("NULL"), this.taxedName);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128359_("TaxedName", Component.Serializer.m_130703_((Component)this.taxedName));
        compound.m_128365_("Amount", (Tag)this.amount.save());
        compound.m_128365_("Category", (Tag)this.category.save());
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.taxedName = Component.Serializer.m_130701_((String)compound.m_128461_("TaxedName"));
        this.amount = MoneyValue.load(compound.m_128469_("Amount"));
        this.category = new TaxEntryCategory(compound.m_128469_("Category"));
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof TaxesCollectedNotification) {
            TaxesCollectedNotification tcn = (TaxesCollectedNotification)other;
            return tcn.taxedName.getString().equals(this.taxedName.getString()) && tcn.amount.equals(this.amount) && tcn.category.matches(this.category);
        }
        return false;
    }
}

