/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.ownership.listing.builtin;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.TeamOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.listing.PotentialOwner;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.api.teams.TeamAPI;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PotentialTeamOwner
extends PotentialOwner {
    public static final int TEAM_PRIORITY = 1000;
    private final long teamID;

    public PotentialTeamOwner(long teamID) {
        super(TeamOwner.of(teamID), 1000);
        this.teamID = teamID;
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        int count = 0;
        ITeam team = TeamAPI.API.GetTeam(this, this.teamID);
        if (team != null) {
            count = team.getMemberCount();
        }
        return IconData.of((ItemLike)Items.f_42680_, String.valueOf(count));
    }

    @Override
    public void appendTooltip(@Nonnull List<Component> tooltip) {
        ITeam team = TeamAPI.API.GetTeam(this, this.teamID);
        if (team != null) {
            LCText.TOOLTIP_OWNER_TEAM.tooltip(tooltip, team.getName(), team.getMemberCount());
        }
    }
}

