/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.value.builtin;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.CoinEntry;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public final class CoinValuePair {
    public final Item coin;
    public final int amount;

    public ItemStack asStack() {
        return new ItemStack((ItemLike)this.coin, this.amount);
    }

    public CoinValuePair addAmount(int amount) {
        return new CoinValuePair(this.coin, this.amount + amount);
    }

    public CoinValuePair removeAmount(int amount) {
        return new CoinValuePair(this.coin, this.amount - amount);
    }

    public CoinValuePair(Item coin, int amount) {
        this.coin = coin;
        this.amount = amount;
    }

    public CoinValuePair copy() {
        return new CoinValuePair(this.coin, this.amount);
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Coin", ForgeRegistries.ITEMS.getKey((Object)this.coin).toString());
        tag.m_128405_("Amount", this.amount);
        return tag;
    }

    public static CoinValuePair load(@Nullable ChainData chainData, @Nonnull CompoundTag tag) {
        return CoinValuePair.from(chainData, (Item)ForgeRegistries.ITEMS.getValue(VersionUtil.parseResource(tag.m_128461_("Coin"))), tag.m_128451_("Amount"));
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130055_(new ItemStack((ItemLike)this.coin));
        buffer.writeInt(this.amount);
    }

    public static CoinValuePair decode(@Nonnull ChainData chainData, @Nonnull FriendlyByteBuf buffer) {
        return CoinValuePair.from(chainData, buffer.m_130267_().m_41720_(), buffer.readInt());
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("Coin", ForgeRegistries.ITEMS.getKey((Object)this.coin).toString());
        json.addProperty("Amount", (Number)this.amount);
        return json;
    }

    @Nullable
    public static CoinValuePair fromJson(@Nonnull ChainData chainData, @Nonnull JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        Item coin = (Item)ForgeRegistries.ITEMS.getValue(VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"Coin")));
        int quantity = GsonHelper.m_13824_((JsonObject)json, (String)"Amount", (int)1);
        if (quantity <= 0) {
            throw new JsonSyntaxException("Coin Amount (" + quantity + ") is <= 0!");
        }
        if (CoinAPI.API.ChainDataOfCoin(coin) == null) {
            throw new JsonSyntaxException("Coin Item " + ForgeRegistries.ITEMS.getKey((Object)coin) + " is not a valid coin!");
        }
        return CoinValuePair.from(chainData, coin, quantity);
    }

    @Nullable
    private static CoinValuePair from(@Nullable ChainData chainData, @Nonnull Item coinItem, int amount) {
        if (coinItem == Items.f_41852_) {
            return null;
        }
        if (chainData == null) {
            return new CoinValuePair(coinItem, amount);
        }
        CoinEntry entry = chainData.findEntry(coinItem);
        if (entry != null) {
            return new CoinValuePair(entry.getCoin(), amount);
        }
        return null;
    }
}

