/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.enchantments;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.enchantments.CoinMagnetEnchantment;
import io.github.lightman314.lightmanscurrency.common.enchantments.MoneyMendingEnchantment;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class EnchantmentUtil {
    private EnchantmentUtil() {
    }

    public static void tickAllEnchantments(@Nonnull LivingEntity entity, @Nullable IMoneyHandler entityMoney) {
        EnchantmentUtil.tickCoinMagnet(entity);
        if (entityMoney == null) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                entityMoney = MoneyAPI.API.GetPlayersMoneyHandler(player);
            } else {
                LightmansCurrency.LogDebug("Cannot run Money Mending tick without a money handler!");
            }
        }
        if (entityMoney != null) {
            EnchantmentUtil.tickMoneyMending(entity, entityMoney);
        }
    }

    public static void tickCoinMagnet(@Nonnull LivingEntity entity) {
        ProfilerFiller filler = entity.m_9236_().m_46473_();
        filler.m_6180_("Coin Magnet Tick");
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)entity);
        if (walletHandler != null) {
            CoinMagnetEnchantment.runEntityTick(walletHandler, entity);
        }
        filler.m_7238_();
    }

    public static void tickMoneyMending(@Nonnull LivingEntity entity, @Nonnull IMoneyHandler entityMoney) {
        ProfilerFiller filler = entity.m_9236_().m_46473_();
        filler.m_6180_("Money Mending Tick");
        MoneyMendingEnchantment.runEntityTick(entity, entityMoney);
        filler.m_7238_();
    }
}

