/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.builtin;

import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.StringOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;

public class ResourceOption
extends ConfigOption<ResourceLocation> {
    public static final ConfigParser<ResourceLocation> PARSER = new Parser();

    protected ResourceOption(@Nonnull Supplier<ResourceLocation> defaultValue) {
        super(defaultValue);
    }

    public static ResourceOption create(@Nonnull ResourceLocation defaultValue) {
        return new ResourceOption(() -> defaultValue);
    }

    public static ResourceOption create(@Nonnull Supplier<ResourceLocation> defaultValue) {
        return new ResourceOption(defaultValue);
    }

    @Override
    @Nonnull
    protected ConfigParser<ResourceLocation> getParser() {
        return PARSER;
    }

    @Override
    @Nullable
    protected String bonusComment() {
        return "Default: " + PARSER.write((ResourceLocation)this.getDefaultValue());
    }

    private static class Parser
    implements ConfigParser<ResourceLocation> {
        private Parser() {
        }

        @Override
        @Nonnull
        public ResourceLocation tryParse(@Nonnull String cleanLine) throws ConfigParsingException {
            String s = StringOption.PARSER.tryParse(cleanLine);
            try {
                return VersionUtil.parseResource(s);
            }
            catch (ResourceLocationException e) {
                throw new ConfigParsingException(s + " is not a valid Resource Location!", e);
            }
        }

        @Override
        @Nonnull
        public String write(@Nonnull ResourceLocation value) {
            return StringOption.PARSER.write(value.toString());
        }
    }
}

