/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Unique;
import teamrazor.deepaether.init.DAItems;
import teamrazor.deepaether.recipe.DARecipeSerializers;

public class FloatyScarfColoring
extends CustomRecipe {
    @Unique
    public static final HashMap<Integer, Integer> TEXTURE_DIFFUSE_COLOR = new HashMap();

    public FloatyScarfColoring(ResourceLocation p_252125_, CraftingBookCategory p_249010_) {
        super(p_252125_, p_249010_);
    }

    public boolean matches(CraftingContainer input, @NotNull Level level) {
        boolean containsScarf = false;
        boolean containsBucket = false;
        int colorCount = 0;
        for (int k = 0; k < input.m_6643_(); ++k) {
            ItemStack itemstack = input.m_8020_(k);
            if (itemstack.m_150930_((Item)DAItems.FLOATY_SCARF.get())) {
                containsScarf = true;
                continue;
            }
            if (itemstack.m_41720_() instanceof DyeItem) {
                ++colorCount;
                continue;
            }
            if (itemstack.m_150930_(Items.f_42447_)) {
                if (containsBucket) {
                    return false;
                }
                containsBucket = true;
                continue;
            }
            if (itemstack.m_41619_()) continue;
            return false;
        }
        if (containsBucket && colorCount > 0) {
            return false;
        }
        return containsScarf;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer input, RegistryAccess provider) {
        CompoundTag tag;
        ArrayList<Integer> colors = new ArrayList<Integer>();
        ItemStack scarf = new ItemStack((ItemLike)DAItems.FLOATY_SCARF.get());
        boolean bucket = false;
        for (int i = 0; i < input.m_6643_(); ++i) {
            ItemStack itemstack = input.m_8020_(i);
            if (itemstack.m_150930_((Item)DAItems.FLOATY_SCARF.get())) {
                scarf = itemstack;
                continue;
            }
            Item item = itemstack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem item2 = (DyeItem)item;
                colors.add(TEXTURE_DIFFUSE_COLOR.get(item2.m_41089_().m_41060_()));
                continue;
            }
            if (!itemstack.m_150930_(Items.f_42447_)) continue;
            bucket = true;
            break;
        }
        int[] currentColors = (tag = (scarf = scarf.m_41777_()).m_41784_()).m_128441_("Colors") ? tag.m_128465_("Colors") : new int[]{-1, -1, -1, -1, -1};
        byte mod = tag.m_128441_("currentModification") ? tag.m_128445_("currentModification") : (byte)0;
        if (bucket) {
            currentColors[mod] = -1;
            byte currentModification = (byte)(mod + 1);
            if (currentModification > 4) {
                currentModification = 0;
            }
            tag.m_128385_("Colors", currentColors);
            tag.m_128344_("currentModification", currentModification);
        } else if (colors.isEmpty()) {
            byte currentModification = (byte)(mod + 1);
            if (currentModification > 4) {
                currentModification = 0;
            }
            tag.m_128344_("currentModification", currentModification);
        } else {
            int applyDyes;
            currentColors[mod] = applyDyes = FloatyScarfColoring.applyDyes(currentColors[mod], colors);
            byte currentModification = (byte)(mod + 1);
            if (currentModification > 4) {
                currentModification = 0;
            }
            tag.m_128385_("Colors", currentColors);
            tag.m_128344_("currentModification", currentModification);
        }
        return scarf.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)DARecipeSerializers.FLOATY_SCARF_COLORING.get();
    }

    public static int applyDyes(int color, List<Integer> dyes) {
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        int i1 = 0;
        int j1 = FastColor.ARGB32.m_13665_((int)color);
        int k1 = FastColor.ARGB32.m_13667_((int)color);
        int l1 = FastColor.ARGB32.m_13669_((int)color);
        l += Math.max(j1, Math.max(k1, l1));
        i += j1;
        j += k1;
        k += l1;
        ++i1;
        for (int dye : dyes) {
            int i2 = FastColor.ARGB32.m_13665_((int)dye);
            int j2 = FastColor.ARGB32.m_13667_((int)dye);
            int k2 = FastColor.ARGB32.m_13669_((int)dye);
            l += Math.max(i2, Math.max(j2, k2));
            i += i2;
            j += j2;
            k += k2;
            ++i1;
        }
        int l2 = i / i1;
        int i3 = j / i1;
        int k3 = k / i1;
        float f = (float)l / (float)i1;
        float f1 = Math.max(l2, Math.max(i3, k3));
        l2 = (int)((float)l2 * f / f1);
        i3 = (int)((float)i3 * f / f1);
        k3 = (int)((float)k3 * f / f1);
        return FastColor.ARGB32.m_13660_((int)0, (int)l2, (int)i3, (int)k3);
    }
}

