/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.entity.eots;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import teamrazor.deepaether.datagen.tags.DATags;
import teamrazor.deepaether.entity.WindCrystal;
import teamrazor.deepaether.entity.eots.EOTSController;
import teamrazor.deepaether.init.DAEntities;
import teamrazor.deepaether.init.DAParticles;
import teamrazor.deepaether.init.DASounds;

public class EOTSSegment
extends FlyingMob
implements Enemy {
    private boolean hasContactedControllerOnLoad = false;
    @Nullable
    protected EOTSSegment parent;
    @Nullable
    private UUID parentUUID;
    private int randomYOffset = 0;
    @Nullable
    protected EOTSController controller;
    @Nullable
    private UUID controllerUUID;
    protected boolean segmentDeathAnimation = false;
    protected boolean finishedDeathAnimation = false;
    private boolean shouldMove = true;
    private boolean isAttacking = false;
    private static final EntityDataAccessor<Boolean> DATA_HEAD_ID = SynchedEntityData.m_135353_(EOTSSegment.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> PARENT_DATA = SynchedEntityData.m_135353_(EOTSSegment.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> DATA_OPEN_MOUTH = SynchedEntityData.m_135353_(EOTSSegment.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EOTSSegment(EntityType<? extends EOTSSegment> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new EotsSegmentMoveControl(this);
        this.f_21365_ = new EotsLookControl(this);
        this.f_19794_ = true;
    }

    protected EOTSSegment(Level level, EOTSSegment parent, int length) {
        this((EntityType<? extends EOTSSegment>)((EntityType)DAEntities.EOTS_SEGMENT.get()), level);
        this.m_146884_(parent.m_20097_().m_252807_());
        level.m_7967_((Entity)this);
        this.setParent(parent);
        if (length < 22) {
            new EOTSSegment(level, this, length + 1);
        }
        this.hasContactedControllerOnLoad = true;
    }

    public EOTSSegment(Level level, EOTSSegment parent, EOTSController controller) {
        this((EntityType<? extends EOTSSegment>)((EntityType)DAEntities.EOTS_SEGMENT.get()), level);
        this.m_146884_(parent.m_20097_().m_252807_());
        level.m_7967_((Entity)this);
        this.setParent(parent);
        this.setController(controller);
        if (this.getController() != null) {
            this.getController().segmentUUIDs.add(this.f_19820_);
        }
        this.hasContactedControllerOnLoad = true;
    }

    public EOTSSegment(Level level, EOTSController controller) {
        this((EntityType<? extends EOTSSegment>)((EntityType)DAEntities.EOTS_SEGMENT.get()), level);
        this.m_146884_(controller.m_20097_().m_252807_().m_82520_(0.0, 6.0, 0.0));
        level.m_7967_((Entity)this);
        this.setController(controller);
        this.hasContactedControllerOnLoad = true;
    }

    @NotNull
    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 96.0).m_22268_(Attributes.f_22281_, 9.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_HEAD_ID, (Object)true);
        this.f_19804_.m_135372_(DATA_OPEN_MOUTH, (Object)false);
        this.f_19804_.m_135372_(PARENT_DATA, (Object)(this.getParent() != null && this.getParentUUID() != null ? this.getParentUUID().toString() : this.m_20149_()));
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag compoundTag) {
        new EOTSSegment(this.m_9236_(), this, 0);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, compoundTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new EotsAirChargeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new EotsAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RandomFloatAroundGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new DeathGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public void m_6043_() {
    }

    public void m_147240_(double pStrength, double pX, double pZ) {
    }

    public void m_8119_() {
        if (!this.hasContactedControllerOnLoad) {
            if (this.getControllerUUID() == null) {
                this.hasContactedControllerOnLoad = true;
            } else if (this.getController() != null) {
                this.getController().segmentUUIDs.add(this.f_19820_);
                if (this.isControllingSegment()) {
                    this.getController().controllingSegments.add(this);
                    this.getController().m_6842_(true);
                }
                this.hasContactedControllerOnLoad = true;
                this.getController().setHasBeenContactedBySegment();
            }
        }
        super.m_8119_();
        if (!this.isControllingSegment()) {
            EOTSSegment parent = this.getParent();
            if (parent != null) {
                float yParentRot;
                float yRot = this.m_146908_();
                float newYRot = Math.abs(yRot - (yParentRot = parent.m_146908_())) < 0.1f ? yRot : Mth.m_14179_((float)0.15f, (float)yRot, (float)yParentRot);
                float xRot = this.m_146909_();
                float xParentRot = parent.m_146909_();
                float newXRot = Math.abs(xRot - xParentRot) < 0.1f ? xRot : Mth.m_14179_((float)0.15f, (float)xRot, (float)xParentRot);
                this.m_19915_(newYRot, newXRot);
                this.m_146884_(parent.m_20182_().m_82546_(parent.m_20154_().m_82542_((double)1.8f, 0.0, (double)1.8f)).m_82546_(parent.m_20154_().m_82548_().m_82542_(0.0, (double)1.8f, 0.0)));
            } else if (this.m_9236_() instanceof ServerLevel) {
                this.setControllingSegment(true);
                if (this.getController() != null) {
                    this.getController().controllingSegments.add(this);
                }
            }
            if (this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 1.0) {
                this.m_7327_((Entity)this.m_5448_());
            }
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)DASounds.EOTS_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)DASounds.EOTS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)DASounds.EOTS_DEATH.get();
    }

    public boolean m_213824_() {
        return true;
    }

    protected void m_6731_(@NotNull LivingEntity pDefender) {
        super.m_6731_(pDefender);
        if (pDefender instanceof Player) {
            Player player = (Player)pDefender;
            player.m_36335_().m_41524_(player.m_21211_().m_41720_(), 1000);
            player.f_19802_ = 20;
        }
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        float health = this.m_21223_();
        if (pSource.m_269533_(DATags.DamageTypes.EOTS_IMMUNE)) {
            return false;
        }
        if (this.getController() != null) {
            if (this.getController().segmentUUIDs.size() == 1 && health - pAmount <= 0.0f) {
                this.segmentDeathAnimation = true;
                this.finishedDeathAnimation = false;
                this.getController().m_6469_(this.createControllerDamageSource((Entity)this), this.getController().m_21223_() - 0.5f);
                this.m_20331_(true);
                return false;
            }
            boolean doHurt = super.m_6469_(pSource, pAmount);
            if (doHurt) {
                this.getController().m_6469_(this.createControllerDamageSource(pSource.m_7639_()), Math.min(pAmount, health));
            }
            return doHurt;
        }
        return super.m_6469_(pSource, pAmount);
    }

    private DamageSource createControllerDamageSource(@Nullable Entity trueSource) {
        return new DamageSource(this.m_9236_().m_269111_().m_269264_().m_269150_(), (Entity)this, trueSource);
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_6667_(@NotNull DamageSource pDamageSource) {
        if (this.getController() != null) {
            this.getController().segmentUUIDs.remove(this.f_19820_);
            if (this.isControllingSegment()) {
                this.getController().controllingSegments.remove((Object)this);
            } else {
                super.m_6667_(pDamageSource);
            }
        } else {
            super.m_6667_(pDamageSource);
        }
    }

    public boolean m_7337_(@NotNull Entity pEntity) {
        return pEntity.m_6095_() != DAEntities.EOTS_SEGMENT.get() || pEntity.m_5829_();
    }

    public boolean m_6549_(@NotNull EntityType<?> pType) {
        return true;
    }

    public boolean isControllingSegment() {
        return (Boolean)this.m_20088_().m_135370_(DATA_HEAD_ID);
    }

    public void setControllingSegment(boolean head) {
        this.m_20088_().m_135381_(DATA_HEAD_ID, (Object)head);
    }

    public boolean isMouthOpen() {
        return (Boolean)this.m_20088_().m_135370_(DATA_OPEN_MOUTH);
    }

    public void setMouthOpen(boolean head) {
        this.m_20088_().m_135381_(DATA_OPEN_MOUTH, (Object)head);
    }

    @Nullable
    private UUID getParentUUID() {
        return this.parentUUID;
    }

    @Nullable
    public EOTSSegment getParent() {
        if (this.parent != null && !this.parent.m_213877_()) {
            return this.parent;
        }
        if (this.parentUUID == null) {
            return null;
        }
        if (this.parent == null && this.m_9236_() instanceof ServerLevel) {
            this.parent = (EOTSSegment)((ServerLevel)this.m_9236_()).m_8791_(this.parentUUID);
            return this.parent;
        }
        return null;
    }

    private void setParentUUID(@Nullable UUID uuid) {
        this.parentUUID = uuid;
    }

    public void setParent(@Nullable EOTSSegment parent) {
        this.setControllingSegment(parent == null);
        this.parent = parent;
        if (parent == null) {
            this.setParentUUID(null);
        } else {
            this.setParentUUID(parent.m_20148_());
        }
    }

    private void setControllerUUID(@Nullable UUID uuid) {
        this.controllerUUID = uuid;
    }

    @Nullable
    private UUID getControllerUUID() {
        return this.controllerUUID;
    }

    public void setController(@Nullable EOTSController controller) {
        this.controller = controller;
        if (controller == null) {
            this.setControllerUUID(null);
        } else {
            this.setControllerUUID(controller.m_20148_());
        }
    }

    @Nullable
    public EOTSController getController() {
        if (this.controller != null && !this.controller.m_213877_()) {
            return this.controller;
        }
        if (this.controllerUUID == null) {
            return null;
        }
        if (this.controller == null && this.m_9236_() instanceof ServerLevel) {
            this.controller = (EOTSController)((ServerLevel)this.m_9236_()).m_8791_(this.getControllerUUID());
            return this.controller;
        }
        return null;
    }

    private int getIdleYPos() {
        if (this.getController() != null) {
            return this.getController().m_20183_().m_123342_() + 21 + this.randomYOffset;
        }
        if (this.m_5448_() != null) {
            return this.m_5448_().m_20183_().m_123342_() + 15 + this.randomYOffset;
        }
        return 255;
    }

    private float getGlobalSpeedModifier() {
        EOTSController controller = this.getController();
        if (controller != null) {
            return Mth.m_14179_((float)Mth.m_14154_((float)(controller.m_21223_() / controller.m_21233_())), (float)1.65f, (float)1.25f);
        }
        return 1.25f;
    }

    private float getGlobalAttackModifier() {
        EOTSController controller = this.getController();
        if (controller != null) {
            if (controller.controllingSegments.size() == 1) {
                return Mth.m_14179_((float)Mth.m_14154_((float)(controller.m_21223_() / controller.m_21233_())), (float)1.65f, (float)1.25f) * 10.0f;
            }
            return Mth.m_14179_((float)Mth.m_14154_((float)(controller.m_21223_() / controller.m_21233_())), (float)1.65f, (float)1.25f);
        }
        return 1.5f;
    }

    public boolean isAroundIdlePos() {
        return this.m_20186_() > (double)(this.getIdleYPos() - 2);
    }

    private void goToIdlePos() {
        float speed = 1.75f;
        if (this.isAroundIdlePos()) {
            speed = 1.0f;
        }
        Object target = this.getController() != null ? this.getController() : (this.m_5448_() != null ? this.m_5448_() : this);
        RandomSource random = this.m_217043_();
        int x = random.m_188503_(9);
        int y = x < 8 ? random.m_188503_(8 - x) : 0;
        double d0 = target.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * (float)x);
        double d2 = target.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * (float)y);
        this.m_21566_().m_6849_(d0, (double)this.getIdleYPos(), d2, (double)speed);
    }

    private void goToIdlePosRelativeToDirection() {
        float speed = 2.5f;
        if (this.isAroundIdlePos()) {
            speed = 1.0f;
        }
        Vec3 lookAngle = this.m_20154_();
        Vec2 vec2 = new Vec2((float)lookAngle.m_7096_(), (float)lookAngle.m_7094_());
        vec2 = vec2.m_165902_();
        double d0 = this.m_20185_() + (double)(vec2.f_82470_ * 5.0f) + (double)this.m_217043_().m_188503_(2);
        double d2 = this.m_20189_() + (double)(vec2.f_82471_ * 5.0f) + (double)this.m_217043_().m_188503_(2);
        this.m_21566_().m_6849_(d0, (double)this.getIdleYPos(), d2, (double)speed);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("Controller")) {
            this.setControllerUUID(tag.m_128342_("Controller"));
        }
        if (tag.m_128403_("Parent")) {
            this.setParentUUID(tag.m_128342_("Parent"));
            this.setControllingSegment(false);
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        if (this.getControllerUUID() != null) {
            tag.m_128362_("Controller", this.getControllerUUID());
        }
        if (this.getParentUUID() != null) {
            tag.m_128362_("Parent", this.getParentUUID());
        }
    }

    protected static class EotsSegmentMoveControl
    extends MoveControl {
        private final EOTSSegment segment;
        private float baseSpeed = 0.1f;

        public EotsSegmentMoveControl(EOTSSegment segment) {
            super((Mob)segment);
            this.segment = segment;
        }

        public void m_8126_() {
            if (this.segment.isControllingSegment()) {
                double d0 = this.segment.f_21342_.m_25000_() - this.segment.m_20185_();
                double d1 = this.segment.f_21342_.m_25001_() - this.segment.m_20186_();
                double d2 = this.segment.f_21342_.m_25002_() - this.segment.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                if (Math.abs(d3) > (double)1.0E-5f) {
                    double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                    d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                    double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                    float f = this.segment.m_146908_();
                    float f1 = (float)Mth.m_14136_((double)d2, (double)d0);
                    float f2 = Mth.m_14177_((float)(this.segment.m_146908_() + 90.0f));
                    float f3 = Mth.m_14177_((float)(f1 * 57.3f));
                    this.segment.m_146922_(Mth.m_14148_((float)f2, (float)f3, (float)this.getTurnSpeed()) - 90.0f);
                    this.segment.f_20883_ = this.segment.m_146908_();
                    this.baseSpeed = Mth.m_14145_((float)f, (float)this.segment.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.baseSpeed, (float)1.8f, (float)(0.005f * (1.8f / this.baseSpeed))) : Mth.m_14121_((float)this.baseSpeed, (float)0.2f, (float)0.025f);
                    double waveFrequency = 0.05;
                    double waveAmplitude = 0.8;
                    double time = this.segment.f_19797_;
                    EOTSController controller = this.segment.getController();
                    if (controller != null) {
                        time += (double)controller.controllingSegments.indexOf((Object)this.segment);
                    }
                    double verticalWave = Math.sin(time * waveFrequency) * waveAmplitude;
                    float f4 = (float)(-(Mth.m_14136_((double)(-d1 + verticalWave), (double)d3) * 180.0 / 3.1415927410125732));
                    this.segment.m_146926_(f4);
                    float f5 = this.segment.m_146908_() + 90.0f;
                    double d6 = (double)(this.getSpeed() * Mth.m_14089_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                    double d7 = (double)(this.getSpeed() * Mth.m_14031_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                    double d8 = (double)(this.getSpeed() * Mth.m_14031_((float)(f4 * ((float)Math.PI / 180)))) * Math.abs((d1 + verticalWave) / d5);
                    Vec3 vec3 = this.segment.m_20184_();
                    this.segment.m_20256_(vec3.m_82549_(new Vec3(d6, d8, d7).m_82546_(vec3).m_82490_(0.2)));
                }
            }
        }

        private float getTurnSpeed() {
            if (!this.segment.isAroundIdlePos() && this.segment.isAttacking) {
                return 10.0f;
            }
            return 5.0f;
        }

        private float getSpeed() {
            return this.baseSpeed * (float)this.segment.f_21342_.m_24999_() * this.segment.getGlobalSpeedModifier();
        }
    }

    protected static class EotsLookControl
    extends LookControl {
        EOTSSegment segment;

        public EotsLookControl(EOTSSegment segment) {
            super((Mob)segment);
            this.segment = segment;
        }

        public void m_8128_() {
            if (this.segment.isAroundIdlePos() && this.segment.isControllingSegment() && !this.segment.segmentDeathAnimation) {
                super.m_8128_();
            }
        }
    }

    protected static class EotsAirChargeGoal
    extends Goal {
        EOTSSegment segment;
        private int attackTimer = 25;
        private int attackDelay = 9;
        private int numberOfAttacks = 0;

        public EotsAirChargeGoal(EOTSSegment segment) {
            this.segment = segment;
        }

        public boolean m_8036_() {
            if (this.segment.isAttacking || !this.segment.isAroundIdlePos() || !this.segment.isControllingSegment() || this.segment.segmentDeathAnimation) {
                return false;
            }
            if (this.attackTimer > 0) {
                --this.attackTimer;
                return false;
            }
            this.attackTimer = (int)((float)this.segment.f_19796_.m_216339_(25, 75) / this.segment.getGlobalAttackModifier());
            return true;
        }

        public boolean m_8045_() {
            if (this.segment.segmentDeathAnimation) {
                return false;
            }
            if (this.attackDelay < -2) {
                return false;
            }
            LivingEntity livingentity = this.segment.m_5448_();
            return livingentity != null && this.segment.m_21040_(livingentity, TargetingConditions.f_26872_);
        }

        public void m_8056_() {
            this.segment.isAttacking = true;
            this.attackDelay = 13;
            this.numberOfAttacks = (int)((float)this.segment.f_19796_.m_216339_(0, 2) * this.segment.getGlobalSpeedModifier());
            this.segment.shouldMove = false;
            this.segment.setMouthOpen(true);
            super.m_8056_();
        }

        public void m_8041_() {
            this.segment.isAttacking = false;
            this.segment.shouldMove = true;
            this.segment.setMouthOpen(false);
            super.m_8041_();
        }

        public void m_8037_() {
            if (this.segment.m_5448_() != null) {
                this.lookAt(this.segment.m_5448_());
                if (this.attackDelay <= 0) {
                    new WindCrystal(this.segment.m_9236_(), (Entity)this.segment, this.segment.m_20154_().m_82542_((double)0.7f, (double)0.7f, (double)0.7f).m_272010_(this.segment.f_19796_, 0.3f));
                    this.segment.m_9236_().m_6263_(null, this.segment.m_20185_(), this.segment.m_20186_(), this.segment.m_20189_(), (SoundEvent)DASounds.EOTS_SHOOT.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
                    if (this.numberOfAttacks > 0) {
                        --this.numberOfAttacks;
                        this.attackDelay = 9;
                    } else {
                        this.attackDelay = -3;
                    }
                }
            }
            --this.attackDelay;
        }

        private void lookAt(LivingEntity target) {
            double d0 = target.m_20185_() - this.segment.m_20185_();
            double d1 = target.m_20188_() - this.segment.m_20188_();
            double d2 = target.m_20189_() - this.segment.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            this.segment.m_146926_(Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 180.0 / 3.1415927410125732)))));
            this.segment.m_146922_(Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 180.0 / 3.1415927410125732) - 90.0f)));
            this.segment.m_5616_(this.segment.m_146908_());
            this.segment.f_19860_ = this.segment.m_146909_();
            this.segment.f_19859_ = this.segment.m_146908_();
        }
    }

    protected static class EotsAttackGoal
    extends Goal {
        EOTSSegment segment;
        private int nextScanTick = 20;
        private boolean hasAttacked = false;
        int maxFollowingTimer = 150;
        Vec3 targetStartPos;
        private AttackType attackType = AttackType.SWEEPING;

        public EotsAttackGoal(EOTSSegment segment) {
            this.segment = segment;
        }

        public boolean m_8036_() {
            if (this.segment.isAttacking || !this.segment.isAroundIdlePos() || !this.segment.isControllingSegment() || !this.segment.shouldMove || this.segment.m_5448_() == null || this.segment.segmentDeathAnimation) {
                return false;
            }
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.hasAttacked = false;
            this.nextScanTick = (int)((float)this.segment.f_19796_.m_216339_(20, 70) / this.segment.getGlobalAttackModifier());
            return true;
        }

        public void m_8056_() {
            this.segment.isAttacking = true;
            this.attackType = this.segment.m_217043_().m_188499_() ? AttackType.SWEEPING : AttackType.FOLLOWING;
            this.maxFollowingTimer = 150;
            if (this.segment.m_5448_() != null) {
                this.targetStartPos = this.segment.m_5448_().m_20182_();
            }
            this.segment.setMouthOpen(true);
        }

        public void m_8041_() {
            this.segment.isAttacking = false;
            this.segment.setMouthOpen(false);
            this.updateYAxisRandomness();
        }

        private void updateYAxisRandomness() {
            this.segment.randomYOffset = this.segment.m_217043_().m_188503_(7);
        }

        public boolean m_8045_() {
            if (this.segment.segmentDeathAnimation) {
                return false;
            }
            if (this.segment.f_20916_ > 0) {
                this.segment.goToIdlePosRelativeToDirection();
                return false;
            }
            if (this.hasAttacked || this.maxFollowingTimer <= 0) {
                return false;
            }
            LivingEntity livingentity = this.segment.m_5448_();
            return livingentity != null && this.segment.m_21040_(livingentity, TargetingConditions.f_26872_);
        }

        public void m_8037_() {
            if (this.segment.m_5448_() != null && this.segment.isControllingSegment()) {
                if (this.targetStartPos == null) {
                    this.hasAttacked = true;
                } else if (this.attackType == AttackType.SWEEPING) {
                    Vec3 pos = this.segment.m_5448_().m_20182_();
                    this.segment.f_21342_.m_6849_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), (double)1.65f);
                    if (this.segment.m_20182_().f_82480_ < this.targetStartPos.f_82480_ || this.segment.m_20182_().f_82480_ < this.segment.m_5448_().m_20182_().f_82480_) {
                        this.hasAttacked = true;
                    }
                } else {
                    Vec3 pos = this.segment.m_5448_().m_20182_().m_82520_(0.0, 1.0, 0.0);
                    this.segment.f_21342_.m_6849_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1.5);
                    --this.maxFollowingTimer;
                }
                if (this.segment.m_20191_().m_82400_((double)0.18f).m_82381_(this.segment.m_5448_().m_20191_())) {
                    this.segment.m_7327_((Entity)this.segment.m_5448_());
                    this.segment.m_5448_().m_20256_(this.segment.m_20154_().m_82542_(1.5, 1.5, 1.5));
                    this.hasAttacked = true;
                }
            }
        }

        private static enum AttackType {
            FOLLOWING,
            SWEEPING;

        }
    }

    protected static class RandomFloatAroundGoal
    extends Goal {
        private final EOTSSegment segment;

        public RandomFloatAroundGoal(EOTSSegment segment) {
            this.segment = segment;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            if (!this.segment.isControllingSegment() || !this.segment.shouldMove || this.segment.segmentDeathAnimation) {
                return false;
            }
            MoveControl moveControl = this.segment.m_21566_();
            if (!moveControl.m_24995_()) {
                return true;
            }
            double d0 = moveControl.m_25000_() - this.segment.m_20185_();
            double d3 = d0 * d0 + (d1 = moveControl.m_25001_() - this.segment.m_20186_()) * d1 + (d2 = moveControl.m_25002_() - this.segment.m_20189_()) * d2;
            return d3 < 5.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            this.segment.goToIdlePos();
        }
    }

    protected static class DeathGoal
    extends Goal {
        private final EOTSSegment segment;
        private boolean hasPositionedAboveController = false;
        private double targetY = 0.0;

        public DeathGoal(EOTSSegment segment) {
            this.segment = segment;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.segment.segmentDeathAnimation && this.segment.getController() != null && !this.segment.getController().m_213877_();
        }

        public boolean m_8045_() {
            if (this.segment.segmentDeathAnimation) {
                MoveControl moveControl = this.segment.m_21566_();
                if (!this.hasPositionedAboveController) {
                    double d2;
                    double d1;
                    double d0 = moveControl.m_25000_() - this.segment.m_20185_();
                    double d3 = d0 * d0 + (d1 = (moveControl.m_25001_() - this.segment.m_20186_()) / 10.0) * d1 + (d2 = moveControl.m_25002_() - this.segment.m_20189_()) * d2;
                    boolean bl = this.hasPositionedAboveController = d3 < 2.0;
                    if (this.hasPositionedAboveController) {
                        if (this.segment.getController() != null) {
                            this.targetY = this.segment.getController().m_20186_() + 6.0;
                            this.segment.m_21566_().m_6849_(moveControl.m_25000_(), this.targetY - 12.0, moveControl.m_25002_(), 1.5);
                        } else {
                            return false;
                        }
                    }
                    return true;
                }
                return this.segment.m_20186_() > this.targetY;
            }
            return false;
        }

        public void m_8041_() {
            this.segment.m_20331_(false);
            this.segment.finishedDeathAnimation = true;
            this.segment.m_6842_(true);
            if (this.segment.getController() != null) {
                this.segment.getController().segmentUUIDs.remove(this.segment.m_20148_());
                Vec3 pos = new Vec3(this.segment.m_20185_(), this.segment.getController().m_20182_().m_7098_() + 6.3, this.segment.m_20189_());
                ((ServerLevel)this.segment.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)DAParticles.EOTS_EXPLOSION.get()), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                this.segment.m_9236_().m_6263_(null, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 2.0f, 1.0f);
                ((ServerLevel)this.segment.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123812_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1, 1.0, 0.0, 0.0, 0.0);
            }
            this.segment.m_6469_(this.segment.m_9236_().m_269111_().m_269264_(), 20.0f);
        }

        public void m_8056_() {
            if (this.segment.getController() != null && !this.segment.getController().m_213877_()) {
                Vec3 pos = this.segment.getController().m_20182_().m_82520_(0.0, 6.0, 0.0);
                this.segment.m_21566_().m_6849_(pos.f_82479_, (double)((float)this.segment.getIdleYPos() + 20.0f), pos.f_82481_, (double)1.4f);
            } else {
                this.segment.m_20331_(false);
                this.segment.finishedDeathAnimation = true;
            }
        }
    }
}

