/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.entity.block;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import teamrazor.deepaether.block.CombinerBlock;
import teamrazor.deepaether.init.DABlockEntityTypes;
import teamrazor.deepaether.recipe.DARecipeTypes;
import teamrazor.deepaether.recipe.combiner.CombinerRecipe;
import teamrazor.deepaether.screen.CombinerMenu;

public class CombinerBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    private static final int FIRST_SLOT = 0;
    private static final int SECOND_SLOT = 1;
    private static final int THIRD_SLOT = 2;
    private static final int OUTPUT_SLOT = 3;
    protected final ContainerData data;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    int processingProgress = 0;
    int processingTotalTime = 78;
    boolean combining;
    int combiningDuration;
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<Container, CombinerRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)DARecipeTypes.COMBINING.get()));

    public CombinerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)DABlockEntityTypes.COMBINER.get(), pPos, pBlockState);
    }

    public CombinerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> CombinerBlockEntity.this.processingProgress;
                    case 1 -> CombinerBlockEntity.this.processingTotalTime;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        CombinerBlockEntity.this.processingProgress = pValue;
                        break;
                    }
                    case 1: {
                        CombinerBlockEntity.this.processingTotalTime = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.deep_aether.combiner");
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.deep_aether.combiner");
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return new CombinerMenu(i, inventory, (Container)this, this.data);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.processingProgress = tag.m_128451_("ProcessingTime");
        this.processingTotalTime = tag.m_128451_("ProcessingTimeTotal");
        CompoundTag recipesUsedTag = tag.m_128469_("RecipesUsed");
        for (String key : recipesUsedTag.m_128431_()) {
            this.recipesUsed.put((Object)ResourceLocation.m_135820_((String)key), recipesUsedTag.m_128451_(key));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("ProcessingTime", this.processingProgress);
        tag.m_128405_("ProcessingTimeTotal", this.processingTotalTime);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        CompoundTag recipesUsedTag = new CompoundTag();
        this.recipesUsed.forEach((location, integer) -> recipesUsedTag.m_128405_(location.toString(), integer.intValue()));
        tag.m_128365_("RecipesUsed", (Tag)recipesUsedTag);
    }

    public NonNullList<ItemStack> getIngredients() {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ingredients.add((ItemStack)this.items.get(0));
        ingredients.add((ItemStack)this.items.get(1));
        ingredients.add((ItemStack)this.items.get(2));
        return (NonNullList)List.copyOf(ingredients);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CombinerBlockEntity blockEntity) {
        boolean changed = false;
        Recipe recipeHolder = blockEntity.quickCheck.m_213657_((Container)blockEntity, level).orElse(null);
        int i = blockEntity.m_6893_();
        boolean isCharging = false;
        if (blockEntity.canProcess(level.m_9598_(), (Recipe<Container>)recipeHolder, blockEntity.items, i)) {
            changed = true;
            ++blockEntity.processingProgress;
            isCharging = true;
            if (blockEntity.processingProgress == blockEntity.processingTotalTime) {
                blockEntity.processingProgress = 0;
                blockEntity.processingTotalTime = CombinerBlockEntity.getTotalProcessingTime(level, blockEntity);
                if (blockEntity.process(level.m_9598_(), (Recipe<Container>)recipeHolder, blockEntity.items, i)) {
                    blockEntity.m_6029_(recipeHolder);
                }
                isCharging = false;
                blockEntity.combining = true;
                blockEntity.combiningDuration = 15;
            }
        } else {
            blockEntity.processingProgress = 0;
        }
        if (blockEntity.combiningDuration <= 0) {
            blockEntity.combining = false;
        }
        if ((Boolean)state.m_61143_((Property)CombinerBlock.CHARGING) != isCharging) {
            changed = true;
            state = (BlockState)state.m_61124_((Property)CombinerBlock.CHARGING, (Comparable)Boolean.valueOf(isCharging));
            level.m_7731_(pos, state, 3);
        }
        if ((Boolean)state.m_61143_((Property)CombinerBlock.COMBINING) != blockEntity.combining) {
            changed = true;
            state = (BlockState)state.m_61124_((Property)CombinerBlock.COMBINING, (Comparable)Boolean.valueOf(blockEntity.combining));
            level.m_7731_(pos, state, 3);
        }
        if (changed) {
            CombinerBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean canProcess(RegistryAccess registryAccess, @Nullable Recipe<Container> recipeHolder, NonNullList<ItemStack> stacks, int maxStackSize) {
        ItemStack left = (ItemStack)stacks.get(0);
        ItemStack middle = (ItemStack)stacks.get(1);
        ItemStack right = (ItemStack)stacks.get(2);
        if (!(left.m_41619_() || middle.m_41619_() || right.m_41619_() || recipeHolder == null)) {
            ItemStack result = recipeHolder.m_5874_((Container)this, registryAccess);
            if (result.m_41619_()) {
                return false;
            }
            ItemStack inResultSlot = (ItemStack)stacks.get(3);
            if (inResultSlot.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)inResultSlot, (ItemStack)result)) {
                return false;
            }
            if (inResultSlot.m_41613_() + result.m_41613_() <= maxStackSize && inResultSlot.m_41613_() + result.m_41613_() <= inResultSlot.m_41741_()) {
                return true;
            }
            return inResultSlot.m_41613_() + result.m_41613_() <= result.m_41741_();
        }
        return false;
    }

    private boolean process(RegistryAccess registryAccess, @Nullable Recipe<Container> recipeHolder, NonNullList<ItemStack> stacks, int maxStackSize) {
        if (recipeHolder != null && this.canProcess(registryAccess, recipeHolder, stacks, maxStackSize)) {
            ItemStack left = (ItemStack)stacks.get(0);
            ItemStack middle = (ItemStack)stacks.get(1);
            ItemStack right = (ItemStack)stacks.get(2);
            ItemStack result = recipeHolder.m_5874_((Container)this, registryAccess);
            ItemStack output = (ItemStack)stacks.get(3);
            if (output.m_41619_()) {
                stacks.set(3, (Object)result.m_41777_());
            } else if (output.m_150930_(result.m_41720_())) {
                output.m_41769_(result.m_41613_());
            }
            left.m_41774_(1);
            middle.m_41774_(1);
            right.m_41774_(1);
            return true;
        }
        return false;
    }

    private static int getTotalProcessingTime(Level level, CombinerBlockEntity blockEntity) {
        return blockEntity.quickCheck.m_213657_((Container)blockEntity, level).map(CombinerRecipe::getProcessingTime).orElse(200);
    }

    public void drops() {
        if (this.f_58857_ != null) {
            Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.f_58858_, this.items);
        }
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return new int[]{3};
        }
        return new int[]{0, 1, 2};
    }

    public boolean m_7155_(int i, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(i, itemStack);
    }

    public boolean m_7157_(int i, ItemStack itemStack, Direction direction) {
        return direction != Direction.DOWN;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean continueProcess = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)stack);
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (index == 0 && !continueProcess) {
            this.processingTotalTime = CombinerBlockEntity.getTotalProcessingTime(this.f_58857_, this);
            this.processingProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_6029_(@Nullable Recipe<?> recipeHolder) {
        if (recipeHolder != null) {
            ResourceLocation location = recipeHolder.m_6423_();
            this.recipesUsed.addTo((Object)location, 1);
        }
    }

    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_58395_(Player player, List<ItemStack> items) {
    }

    public void m_5809_(StackedContents stackedContents) {
        for (ItemStack itemstack : this.items) {
            stackedContents.m_36491_(itemstack);
        }
    }
}

