/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.entity;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.data.resources.registries.AetherDamageTypes;
import com.aetherteam.aether.entity.projectile.crystal.AbstractCrystal;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import teamrazor.deepaether.datagen.tags.DATags;
import teamrazor.deepaether.entity.GentleWind;
import teamrazor.deepaether.init.DAEntities;

public class WindCrystal
extends AbstractCrystal {
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    public double xPower = 0.0;
    public double yPower;
    public double zPower = 0.0;
    private static final double baseSpeed = 0.3;
    private static final EntityDataAccessor<Boolean> IS_FRIENDLY = SynchedEntityData.m_135353_(WindCrystal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public WindCrystal(EntityType<WindCrystal> entityType, Level level) {
        super(entityType, level);
    }

    public WindCrystal(Level level, Entity shooter, Vec3 direction) {
        this((EntityType<WindCrystal>)((EntityType)DAEntities.WIND_CRYSTAL.get()), level);
        this.m_5602_(shooter);
        this.m_6034_(shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_());
        this.yPower = -0.15;
        this.m_20256_(direction);
        this.m_9236_().m_7967_((Entity)this);
    }

    public WindCrystal(Level level, Entity shooter, double x, double y, double z) {
        this(level, shooter, new Vec3(x, y, z));
    }

    public WindCrystal(Level level, Entity shooter, Vec3 direction, boolean friendly) {
        this(level, shooter, direction);
        this.setFriendly(friendly);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_FRIENDLY, (Object)false);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            GentleWind gentleWind;
            Player player;
            Entity entity2;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.m_19749_() != null && (entity2 = this.m_19749_()) instanceof GentleWind && (player = (gentleWind = (GentleWind)entity2).getOwner()) != null && !gentleWind.wantsToAttack(livingEntity, (LivingEntity)player)) {
                return;
            }
            if (livingEntity.m_6469_(AetherDamageTypes.indirectEntityDamageSource((Level)this.m_9236_(), (ResourceKey)DamageTypes.f_268534_, (Entity)this, (Entity)this.m_19749_()), this.getDamage())) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getImpactExplosionSoundEvent(), SoundSource.HOSTILE, 2.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 1.2f);
                this.m_146870_();
            }
        }
    }

    private float getDamage() {
        if (this.isFriendly()) {
            return 6.0f;
        }
        return 10.0f;
    }

    protected boolean m_5603_(Entity pTarget) {
        if (this.m_19749_() != null && pTarget.m_7306_(this.m_19749_())) {
            return false;
        }
        if (pTarget instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pTarget;
            if (this.isFriendly() ? livingEntity.m_6095_().m_204039_(DATags.Entities.FRIENDLY_WIND_CHARGE_BLACKLIST) : livingEntity.m_6095_().m_204039_(DATags.Entities.WIND_CHARGE_BLACKLIST)) {
                return false;
            }
        }
        return super.m_5603_(pTarget);
    }

    protected void m_8060_(BlockHitResult result) {
        this.m_5834_();
        if (!this.isFriendly()) {
            if (result.m_82434_() == Direction.UP) {
                float offset = (float)this.f_19796_.m_188503_(200) / 1000.0f;
                new WindCrystal(this.m_9236_(), (Entity)this, 0.3 + (double)offset, 0.0, 0.3 - (double)offset);
                new WindCrystal(this.m_9236_(), (Entity)this, -0.3 + (double)offset, 0.0, 0.3 + (double)offset);
                new WindCrystal(this.m_9236_(), (Entity)this, 0.3 - (double)offset, 0.0, -0.3 - (double)offset);
                new WindCrystal(this.m_9236_(), (Entity)this, -0.3 - (double)offset, 0.0, -0.3 + (double)offset);
            }
            this.m_9236_().m_245803_((Entity)this, result.m_82425_(), (SoundEvent)AetherSoundEvents.ENTITY_ICE_CRYSTAL_EXPLODE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            if (this.isBreakable(this.m_9236_().m_8055_(result.m_82425_())) && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                this.m_9236_().m_46961_(result.m_82425_(), true);
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_(), this.m_20186_() + ((double)this.f_19796_.m_188501_() - 0.5), this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_(), this.m_20186_() + ((double)this.f_19796_.m_188501_() - 0.5), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    private boolean isBreakable(BlockState blockState) {
        return !blockState.m_204336_(AetherTags.Blocks.VALKYRIE_QUEEN_UNBREAKABLE) && blockState.m_60734_().m_155943_() >= 0.0f && blockState.m_60734_().m_155943_() < 100.0f;
    }

    @Nonnull
    protected SoundEvent getImpactExplosionSoundEvent() {
        return (SoundEvent)AetherSoundEvents.ENTITY_ICE_CRYSTAL_EXPLODE.get();
    }

    public boolean m_6087_() {
        return true;
    }

    protected ParticleOptions getExplosionParticle() {
        return ParticleTypes.f_123796_;
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128347_("XSpeed", this.xPower);
        tag.m_128347_("YSpeed", this.yPower);
        tag.m_128347_("ZSpeed", this.zPower);
        tag.m_128379_("isFriendly", this.isFriendly());
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        this.xPower = tag.m_128459_("XSpeed");
        this.yPower = tag.m_128459_("YSpeed");
        this.zPower = tag.m_128459_("ZSpeed");
        this.setFriendly(tag.m_128471_("isFriendly"));
    }

    public void m_5602_(@Nullable Entity owner) {
        if (owner != null) {
            this.ownerUUID = owner.m_20148_();
            this.cachedOwner = owner;
        }
    }

    @Nullable
    public Entity m_19749_() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void setFriendly(boolean friendly) {
        this.f_19804_.m_135381_(IS_FRIENDLY, (Object)friendly);
    }

    public boolean isFriendly() {
        return (Boolean)this.f_19804_.m_135370_(IS_FRIENDLY);
    }
}

