/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.entity;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.monster.Zephyr;
import com.aetherteam.aether.entity.projectile.ZephyrSnowball;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BabyZephyr
extends Zephyr {
    public BabyZephyr(EntityType<? extends Zephyr> type, Level level) {
        super(type, level);
        this.f_21342_ = new BabyZephyrMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomFloatAroundGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new Zephyr.ZephyrLookGoal((Zephyr)this));
        this.f_21345_.m_25352_(4, (Goal)new BabyZephyrMeeleGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new ZephyrShootSnowballGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
    }

    protected void updateRandomPos() {
        RandomSource random = this.m_217043_();
        double d0 = this.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 4.0f);
        double d1 = this.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 4.0f);
        double d2 = this.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 4.0f);
        this.m_21566_().m_6849_(d0, d1, d2, 1.5);
    }

    protected static class BabyZephyrMoveControl
    extends MoveControl {
        private final BabyZephyr zephyr;
        private int floatDuration;

        public BabyZephyrMoveControl(BabyZephyr zephyr) {
            super((Mob)zephyr);
            this.zephyr = zephyr;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.zephyr.m_217043_().m_188503_(5) + 2;
                Vec3 vec3d = new Vec3(this.f_24975_ - this.zephyr.m_20185_(), this.f_24976_ - this.zephyr.m_20186_(), this.f_24977_ - this.zephyr.m_20189_());
                double d0 = vec3d.m_82553_();
                if (this.canReach(vec3d = vec3d.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.zephyr.m_20256_(this.zephyr.m_20184_().m_82549_(vec3d.m_82490_(0.1 * this.f_24978_)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 pos, int distance) {
            AABB axisalignedbb = this.zephyr.m_20191_();
            for (int i = 1; i < distance; ++i) {
                axisalignedbb = axisalignedbb.m_82383_(pos);
                if (this.zephyr.m_9236_().m_45756_((Entity)this.zephyr, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    protected static class RandomFloatAroundGoal
    extends Goal {
        private final BabyZephyr zephyr;

        public RandomFloatAroundGoal(BabyZephyr zephyr) {
            this.zephyr = zephyr;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl moveControl = this.zephyr.m_21566_();
            if (!moveControl.m_24995_()) {
                return true;
            }
            double d0 = moveControl.m_25000_() - this.zephyr.m_20185_();
            double d3 = d0 * d0 + (d1 = moveControl.m_25001_() - this.zephyr.m_20186_()) * d1 + (d2 = moveControl.m_25002_() - this.zephyr.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            this.zephyr.updateRandomPos();
        }
    }

    public static class BabyZephyrMeeleGoal
    extends Goal {
        int cooldown = 20;
        int time = 0;
        private final BabyZephyr zephyr;
        private boolean hasAttacked = false;

        public BabyZephyrMeeleGoal(BabyZephyr zephyr) {
            this.zephyr = zephyr;
        }

        public boolean m_8036_() {
            if (this.zephyr.m_5448_() == null || !this.zephyr.m_142582_((Entity)this.zephyr.m_5448_())) {
                return false;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.cooldown = this.zephyr.f_19796_.m_188503_(20) + 20;
            return true;
        }

        public boolean m_8045_() {
            if (this.hasAttacked) {
                this.zephyr.updateRandomPos();
                return false;
            }
            if (this.time > 200) {
                return false;
            }
            LivingEntity livingentity = this.zephyr.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.zephyr.f_20916_ > 0) {
                this.zephyr.updateRandomPos();
                return false;
            }
            return this.zephyr.m_21444_(livingentity.m_20183_());
        }

        public void m_8056_() {
            this.time = 0;
            this.hasAttacked = false;
            if (this.zephyr.m_5448_() != null) {
                Vec3 target = this.zephyr.m_5448_().m_20182_().m_82520_(0.0, 2.0, 0.0);
                this.zephyr.m_21566_().m_6849_(target.m_7096_(), target.m_7098_(), target.m_7094_(), 2.0);
            }
            this.zephyr.m_21561_(true);
        }

        public void m_8041_() {
            LivingEntity livingentity = this.zephyr.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.zephyr.m_6710_(null);
            }
            this.zephyr.m_21561_(false);
            this.zephyr.updateRandomPos();
        }

        public void m_8037_() {
            ++this.time;
            LivingEntity living = this.zephyr.m_5448_();
            if (living != null) {
                Vec3 target = this.zephyr.m_5448_().m_20182_().m_82520_(0.0, 2.0, 0.0);
                this.zephyr.m_21566_().m_6849_(target.m_7096_(), target.m_7098_(), target.m_7094_(), 1.5 * (1.0 + (double)this.time / 100.0));
                if (this.zephyr.m_20182_().m_82557_(target) < (double)1.3f) {
                    living.m_6469_(this.zephyr.m_9236_().m_269111_().m_269333_((LivingEntity)this.zephyr), 4.0f);
                    this.hasAttacked = true;
                }
            }
        }
    }

    protected static class ZephyrShootSnowballGoal
    extends Goal {
        private final BabyZephyr zephyr;

        public ZephyrShootSnowballGoal(BabyZephyr zephyr) {
            this.zephyr = zephyr;
        }

        public boolean m_8036_() {
            if (this.zephyr.m_5912_()) {
                return false;
            }
            return this.zephyr.m_5448_() != null;
        }

        public void m_8056_() {
            this.zephyr.setChargeTime(0);
        }

        public void m_8041_() {
            this.zephyr.setChargeTime(0);
        }

        public void m_8037_() {
            LivingEntity livingEntity = this.zephyr.m_5448_();
            if (livingEntity != null) {
                if (livingEntity.m_20280_((Entity)this.zephyr) < 1600.0 && this.zephyr.m_142582_((Entity)livingEntity)) {
                    Level level = this.zephyr.m_9236_();
                    this.zephyr.setChargeTime(this.zephyr.getChargeTime() + 1);
                    if (this.zephyr.getChargeTime() == 2) {
                        if (this.zephyr.m_7515_() != null) {
                            this.zephyr.m_5496_(this.zephyr.m_7515_(), this.zephyr.m_6121_(), (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f + 1.0f);
                        }
                    } else if (this.zephyr.getChargeTime() == 12) {
                        Vec3 look = this.zephyr.m_20252_(1.0f);
                        double accelX = livingEntity.m_20185_() - (this.zephyr.m_20185_() + look.m_7096_() * 4.0);
                        double accelY = livingEntity.m_20227_(0.5) - (0.5 + this.zephyr.m_20227_(0.5));
                        double accelZ = livingEntity.m_20189_() - (this.zephyr.m_20189_() + look.m_7094_() * 4.0);
                        this.zephyr.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_ZEPHYR_SHOOT.get(), this.zephyr.m_6121_(), (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f + 1.0f);
                        ZephyrSnowball snowball = new ZephyrSnowball(level, (LivingEntity)this.zephyr, accelX * 2.0, accelY * 2.0, accelZ * 2.0);
                        snowball.m_6034_(this.zephyr.m_20185_() + look.m_7096_() * 4.0, this.zephyr.m_20227_(0.5) + 0.5, this.zephyr.m_20189_() + look.m_7094_() * 4.0);
                        level.m_7967_((Entity)snowball);
                        this.zephyr.setChargeTime(-1);
                    }
                } else if (this.zephyr.getChargeTime() > 0) {
                    this.zephyr.setChargeTime(this.zephyr.getChargeTime() - 1);
                }
            }
        }
    }
}

