/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import teamrazor.deepaether.client.renderer.DAModelLayers;
import teamrazor.deepaether.item.dungeon.brass.WindShieldItem;
import teamrazor.deepaether.networking.DeepAetherPlayer;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class WindShieldRenderer
implements ICurioRenderer {
    private final HumanoidModel<LivingEntity> shieldModel = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(DAModelLayers.WIND_SHIELD));
    public final HumanoidModel<LivingEntity> shieldModelArm = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(DAModelLayers.WIND_SHIELD_ARM));
    public final PlayerModel<LivingEntity> dummyArm = new PlayerModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171162_), false);
    public final PlayerModel<LivingEntity> dummyArmSlim = new PlayerModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171166_), true);

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext reference, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource buffer, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Player player;
        Optional aetherPlayerOptional;
        LivingEntity livingEntity = reference.entity();
        if (livingEntity instanceof Player && (aetherPlayerOptional = DeepAetherPlayer.get(player = (Player)livingEntity).resolve()).isPresent() && ((DeepAetherPlayer)aetherPlayerOptional.get()).getWindShieldCooldown() > 0) {
            return;
        }
        WindShieldItem shield = (WindShieldItem)stack.m_41720_();
        ResourceLocation texture = shield.getWindShieldTexture();
        HumanoidModel<LivingEntity> model = this.shieldModel;
        ICurioRenderer.followHeadRotations((LivingEntity)reference.entity(), (ModelPart[])new ModelPart[]{model.f_102808_});
        ICurioRenderer.followBodyRotations((LivingEntity)reference.entity(), (HumanoidModel[])new HumanoidModel[]{model});
        float f = (float)livingEntity.f_19797_ + partialTicks;
        VertexConsumer consumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110436_((ResourceLocation)texture, (float)(f * 0.02f % 1.0f), (float)0.0f), (boolean)false, (boolean)stack.m_41793_());
        model.m_7695_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderFirstPerson(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, HumanoidArm arm) {
        Optional aetherPlayerOptional = DeepAetherPlayer.get((Player)player).resolve();
        if (aetherPlayerOptional.isEmpty() || ((DeepAetherPlayer)aetherPlayerOptional.get()).getWindShieldCooldown() > 0) {
            return;
        }
        boolean isSlim = player.m_108564_().equals("slim");
        if (!player.m_20145_()) {
            this.setupHand(isSlim ? this.dummyArmSlim : this.dummyArm, poseStack, buffer, packedLight, player, arm, isSlim);
        }
        this.setupShieldOnHand(stack, this.shieldModelArm, poseStack, buffer, packedLight, player, arm, isSlim);
    }

    private void setupShieldOnHand(ItemStack stack, HumanoidModel<LivingEntity> model, PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, HumanoidArm arm, boolean isSlim) {
        this.setupModel(model, player);
        WindShieldItem shield = (WindShieldItem)stack.m_41720_();
        VertexConsumer consumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110436_((ResourceLocation)shield.getWindShieldTexture(), (float)((float)player.f_19797_ * 0.02f % 1.0f), (float)0.0f), (boolean)false, (boolean)stack.m_41793_());
        if (isSlim) {
            poseStack.m_252880_((arm != HumanoidArm.LEFT ? 1.0f : -1.0f) * 0.05f, 0.0f, 0.0f);
        }
        if (arm == HumanoidArm.RIGHT) {
            this.renderShieldOnHand(model.f_102811_, poseStack, packedLight, consumer);
        } else if (arm == HumanoidArm.LEFT) {
            this.renderShieldOnHand(model.f_102812_, poseStack, packedLight, consumer);
        }
    }

    private void setupHand(PlayerModel<LivingEntity> model, PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, HumanoidArm arm, boolean isSlim) {
        this.setupModel((HumanoidModel<LivingEntity>)model, player);
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)player.m_108560_()));
        if (isSlim) {
            poseStack.m_252880_((arm != HumanoidArm.LEFT ? 1.0f : -1.0f) * -0.05f, 0.0f, 0.0f);
        }
        if (arm == HumanoidArm.RIGHT) {
            this.renderHand(model.f_102811_, model.f_103375_, poseStack, packedLight, consumer);
        } else if (arm == HumanoidArm.LEFT) {
            this.renderHand(model.f_102812_, model.f_103374_, poseStack, packedLight, consumer);
        }
    }

    private void setupModel(HumanoidModel<LivingEntity> model, AbstractClientPlayer player) {
        model.m_8009_(false);
        model.f_102608_ = 0.0f;
        model.f_102817_ = false;
        model.f_102818_ = 0.0f;
        model.m_6973_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    private void renderShieldOnHand(ModelPart shieldArm, PoseStack poseStack, int packedLight, VertexConsumer consumer) {
        shieldArm.f_104207_ = true;
        shieldArm.f_104203_ = 0.0f;
        shieldArm.m_104306_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderHand(ModelPart dummyArm, ModelPart dummySleeve, PoseStack poseStack, int packedLight, VertexConsumer consumer) {
        dummyArm.f_104207_ = true;
        dummySleeve.f_104207_ = true;
        dummyArm.f_104203_ = 0.0f;
        dummySleeve.f_104203_ = 0.0f;
        dummyArm.m_104306_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        dummySleeve.m_104306_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

