/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.block;

import com.aetherteam.aether.effect.AetherEffects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import teamrazor.deepaether.advancement.PoisonTrigger;
import teamrazor.deepaether.fluids.DAFluidInteraction;
import teamrazor.deepaether.init.DAParticles;
import teamrazor.deepaether.recipe.DARecipeTypes;
import teamrazor.deepaether.recipe.poison.PoisonRecipe;

public class PoisonBlock
extends LiquidBlock {
    boolean COUNT = false;
    int TIME = 0;

    public PoisonBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties properties) {
        super(supplier, properties);
    }

    public void m_141947_(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && !((livingEntity = (LivingEntity)entity) instanceof ArmorStand)) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)AetherEffects.INEBRIATION.get(), 80, 0, false, false));
        }
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        double d0 = blockPos.m_123341_();
        double d1 = blockPos.m_123342_();
        double d2 = blockPos.m_123343_();
        level.m_7107_((ParticleOptions)DAParticles.POISON_BUBBLES.get(), d0 + (double)randomSource.m_188501_(), d1 + (double)randomSource.m_188501_(), d2 + (double)randomSource.m_188501_(), 0.0, 0.04, 0.0);
        if (randomSource.m_188503_(10) == 0) {
            level.m_7785_(d0, d1, d2, SoundEvents.f_11773_, SoundSource.BLOCKS, 0.2f + randomSource.m_188501_() * 0.2f, 0.9f + randomSource.m_188501_() * 0.15f, false);
        }
        super.m_214162_(blockState, level, blockPos, randomSource);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.COUNT && this.TIME < 200) {
            ++this.TIME;
        } else {
            this.TIME = 0;
            this.COUNT = false;
        }
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).m_7292_(new MobEffectInstance((MobEffect)AetherEffects.INEBRIATION.get(), 100, 0, false, false));
            this.playHissingSound(level, entity, pos);
        } else if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            Item TRANSFORM_ITEM = null;
            int count = itemEntity.m_32055_().m_41613_();
            if (!level.m_5776_()) {
                for (PoisonRecipe recipe : level.m_7465_().m_44013_((RecipeType)DARecipeTypes.POISON_RECIPE.get())) {
                    if (((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0].m_41720_() != itemEntity.m_32055_().m_41720_()) continue;
                    TRANSFORM_ITEM = recipe.getResult().m_41720_();
                    this.COUNT = true;
                }
            }
            if (TRANSFORM_ITEM == null) {
                return;
            }
            this.spawnBubbleParticles(level, (Entity)itemEntity, pos);
            this.playHissingSound(level, (Entity)itemEntity, pos);
            if (this.TIME > 2 && itemEntity.m_6084_()) {
                this.COUNT = false;
                Entity entity2 = itemEntity.m_19749_();
                if (entity2 instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity2;
                    PoisonTrigger.INSTANCE.trigger(player, itemEntity.m_32055_());
                }
                itemEntity.m_146870_();
                entity.m_5552_(new ItemStack((ItemLike)TRANSFORM_ITEM, count), 0.0f);
                entity.m_20242_(true);
            }
        }
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState state, boolean b) {
        if (!DAFluidInteraction.canInteract(level, blockPos)) {
            level.m_186469_(blockPos, blockState.m_60819_().m_76152_(), this.getFluid().m_6718_((LevelReader)level));
        }
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos1, boolean b) {
        if (!DAFluidInteraction.canInteract(level, blockPos)) {
            level.m_186469_(blockPos, blockState.m_60819_().m_76152_(), this.getFluid().m_6718_((LevelReader)level));
        }
    }

    private void spawnBubbleParticles(Level level, Entity entity, BlockPos pos) {
        if (!level.f_46443_ && entity.m_6084_()) {
            BlockPos itemPos = entity.m_20097_();
            ServerLevel serverlevel = (ServerLevel)level;
            serverlevel.m_8767_((ParticleOptions)((SimpleParticleType)DAParticles.POISON_BUBBLES.get()), (double)itemPos.m_123341_() + level.f_46441_.m_188500_(), (double)(pos.m_123342_() + 1), (double)itemPos.m_123343_() + level.f_46441_.m_188500_(), 1, 0.0, 0.0, 0.2, 0.3);
        }
    }

    private void playHissingSound(Level level, Entity entity, BlockPos pos) {
        if (level.f_46441_.m_188503_(25) == 0) {
            level.m_245803_(entity, pos, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.2f + level.f_46441_.m_188501_() * 0.2f, 0.9f + level.f_46441_.m_188501_() * 0.15f);
        }
    }
}

