/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.compat.tracks;

import com.railwayteam.railways.ModSetup;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.compat.tracks.NarrowGaugeCompatTrackBlockStateGenerator;
import com.railwayteam.railways.compat.tracks.SoftIngredient;
import com.railwayteam.railways.compat.tracks.TrackCompatUtils;
import com.railwayteam.railways.compat.tracks.WideGaugeCompatTrackBlockStateGenerator;
import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.mixin.AccessorIngredient$TagValue;
import com.railwayteam.railways.multiloader.CommonTags;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRItems;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.TextUtils;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyItem;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackMaterialFactory;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class GenericTrackCompat {
    private static final Map<String, GenericTrackCompat> ALL = new HashMap<String, GenericTrackCompat>();
    public final Mods mod;
    public final String modid;
    public boolean modLoaded;
    protected final Map<String, TrackMaterial> MATERIALS = new HashMap<String, TrackMaterial>();
    protected final Map<String, NonNullSupplier<? extends TrackBlock>> BLOCKS = new HashMap<String, NonNullSupplier<? extends TrackBlock>>();

    public GenericTrackCompat(Mods mod) {
        this.mod = mod;
        this.modid = mod.asId();
        this.modLoaded = mod.isLoaded;
        ALL.put(this.modid, this);
    }

    public static GenericTrackCompat get(String modid) {
        return ALL.get(modid);
    }

    public static boolean isDataGen() {
        return Utils.isEnvVarTrue("DATAGEN");
    }

    protected final boolean shouldRegisterMissing() {
        return GenericTrackCompat.isDataGen() || CRConfigs.getRegisterMissingTracks() || this.modLoaded;
    }

    public void register(String ... names) {
        for (String name : names) {
            Optional baseBlock = BuiltInRegistries.f_256975_.m_6612_(this.getSlabLocation(name));
            if (baseBlock.isEmpty()) {
                if (!this.shouldRegisterMissing()) continue;
                if (GenericTrackCompat.isDataGen() || Utils.isDevEnv()) {
                    Railways.LOGGER.error("Failed to locate base block at {} for {}", (Object)this.getSlabLocation(name), (Object)this.asResource(name));
                }
            }
            TrackMaterial standardMaterial = TrackCompatUtils.buildCompatModels(this, TrackMaterialFactory.make((ResourceLocation)this.asResource(name)).lang(this.langName(name)).block(() -> this.BLOCKS.get(name)).particle(this.asResource("block/track/" + name + "/standard_track_crossing_" + name)).sleeper(baseBlock.map(xva$0 -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{xva$0})).orElseGet(() -> SoftIngredient.of(this.getSlabLocation(name)))).rails(this.getIngredientForRail()));
            this.MATERIALS.put(name, standardMaterial);
            BlockEntry<TrackBlock> standardBlock = TrackCompatUtils.makeTrack(standardMaterial);
            this.BLOCKS.put(name, (NonNullSupplier<? extends TrackBlock>)standardBlock);
            CRItems.ITEM_INCOMPLETE_TRACK.put(standardMaterial, (ItemEntry<SequencedAssemblyItem>)Railways.registrate().item("track_incomplete_" + this.modid + "_" + standardMaterial.resourceName(), SequencedAssemblyItem::new).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{this.asResource("item/track_incomplete/track_incomplete_" + standardMaterial.resourceName())})).lang("Incomplete " + standardMaterial.langName + " Track").register());
            TrackMaterial wideMaterial = this.wideVariant(standardMaterial);
            this.MATERIALS.put(name + "_wide", wideMaterial);
            CRTrackMaterials.WIDE_GAUGE.put(standardMaterial, wideMaterial);
            CRTrackMaterials.WIDE_GAUGE_REVERSE.put(wideMaterial, standardMaterial);
            BlockEntry<TrackBlock> wideBlock = TrackCompatUtils.makeTrack(wideMaterial, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((WideGaugeCompatTrackBlockStateGenerator)WideGaugeCompatTrackBlockStateGenerator.create()).generate(arg_0, arg_1)));
            CRBlocks.WIDE_GAUGE_TRACKS.put(wideMaterial, (NonNullSupplier<TrackBlock>)wideBlock);
            this.BLOCKS.put(name + "_wide", (NonNullSupplier<? extends TrackBlock>)wideBlock);
            CRItems.ITEM_INCOMPLETE_TRACK.put(wideMaterial, (ItemEntry<SequencedAssemblyItem>)Railways.registrate().item("track_incomplete_" + this.modid + "_" + wideMaterial.resourceName(), SequencedAssemblyItem::new).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{this.asResource("item/track_incomplete/track_incomplete_" + wideMaterial.resourceName())})).lang("Incomplete " + wideMaterial.langName + " Track").register());
            TrackMaterial narrowMaterial = this.narrowVariant(standardMaterial);
            this.MATERIALS.put(name + "_narrow", narrowMaterial);
            CRTrackMaterials.NARROW_GAUGE.put(standardMaterial, narrowMaterial);
            CRTrackMaterials.NARROW_GAUGE_REVERSE.put(narrowMaterial, standardMaterial);
            BlockEntry<TrackBlock> narrowBlock = TrackCompatUtils.makeTrack(narrowMaterial, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((NarrowGaugeCompatTrackBlockStateGenerator)NarrowGaugeCompatTrackBlockStateGenerator.create()).generate(arg_0, arg_1)));
            CRBlocks.NARROW_GAUGE_TRACKS.put(narrowMaterial, (NonNullSupplier<TrackBlock>)narrowBlock);
            this.BLOCKS.put(name + "_narrow", (NonNullSupplier<? extends TrackBlock>)narrowBlock);
            CRItems.ITEM_INCOMPLETE_TRACK.put(narrowMaterial, (ItemEntry<SequencedAssemblyItem>)Railways.registrate().item("track_incomplete_" + this.modid + "_" + narrowMaterial.resourceName(), SequencedAssemblyItem::new).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{this.asResource("item/track_incomplete/track_incomplete_" + narrowMaterial.resourceName())})).lang("Incomplete " + narrowMaterial.langName + " Track").register());
        }
    }

    protected String langName(String name) {
        return TextUtils.titleCaseConversion(name.replace('_', ' '));
    }

    protected ResourceLocation asResource(String path) {
        return new ResourceLocation(this.modid, path);
    }

    protected ResourceLocation getSlabLocation(String name) {
        return this.asResource(name + "_slab");
    }

    protected String getLang(String name) {
        return name;
    }

    protected Ingredient getIngredientForRail() {
        return Ingredient.m_43938_(Stream.of(AccessorIngredient$TagValue.railways$create(CommonTags.IRON_NUGGETS.tag), AccessorIngredient$TagValue.railways$create(CommonTags.ZINC_NUGGETS.tag)));
    }

    private TrackMaterial wideVariant(TrackMaterial material) {
        String path = material.id.m_135815_() + "_wide";
        return TrackCompatUtils.buildCompatModels(this, TrackMaterialFactory.make((ResourceLocation)this.asResource(path)).lang("Wide " + material.langName).trackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE).block(() -> CRBlocks.WIDE_GAUGE_TRACKS.get(CRTrackMaterials.WIDE_GAUGE.get(material))).particle(material.particle).noRecipeGen());
    }

    private TrackMaterial narrowVariant(TrackMaterial material) {
        String path = material.id.m_135815_() + "_narrow";
        return TrackCompatUtils.buildCompatModels(this, TrackMaterialFactory.make((ResourceLocation)this.asResource(path)).lang("Narrow " + material.langName).trackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE).block(() -> CRBlocks.NARROW_GAUGE_TRACKS.get(CRTrackMaterials.NARROW_GAUGE.get(material))).particle(material.particle).noRecipeGen());
    }

    static {
        ModSetup.useTracksTab();
    }
}

