/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.utils;

import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.block.ChalkMarkBlock;
import io.github.mortuusars.chalk.core.Mark;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.core.SymbolOrientation;
import io.github.mortuusars.chalk.core.SymbolUnlocking;
import io.github.mortuusars.chalk.data.Lang;
import io.github.mortuusars.chalk.network.Packets;
import io.github.mortuusars.chalk.network.packet.ClientboundSelectSymbolPacket;
import io.github.mortuusars.chalk.render.ChalkColors;
import io.github.mortuusars.chalk.utils.MarkDrawHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkDrawingContext {
    @Nullable
    private static MarkDrawingContext storedContext;
    private final Player player;
    private final Level level;
    private final BlockHitResult hitResult;
    private final InteractionHand drawingHand;
    private final SymbolOrientation initialOrientation;

    public MarkDrawingContext(Player player, @NotNull BlockHitResult hitResult, InteractionHand drawingHand) {
        this.player = player;
        this.level = player.m_9236_();
        this.hitResult = hitResult;
        this.drawingHand = drawingHand;
        this.initialOrientation = SymbolOrientation.fromClickLocationAll(hitResult.m_82450_(), hitResult.m_82434_());
    }

    public static void storeContext(MarkDrawingContext context) {
        storedContext = context;
    }

    @Nullable
    public static MarkDrawingContext getStoredContext() {
        return storedContext;
    }

    public static void clearStoredContext() {
        storedContext = null;
    }

    public boolean canDraw() {
        return MarkDrawingContext.canBeDrawnOn(this.hitResult.m_82425_(), this.getMarkFacing(), this.level);
    }

    public Player getPlayer() {
        return this.player;
    }

    public BlockPos getMarkBlockPos() {
        return this.hitResult.m_82425_().m_121945_(this.getMarkFacing());
    }

    @NotNull
    public Direction getMarkFacing() {
        return this.hitResult.m_82434_();
    }

    public SymbolOrientation getInitialOrientation() {
        return this.initialOrientation;
    }

    public InteractionHand getDrawingHand() {
        return this.drawingHand;
    }

    public void openSymbolSelectionScreen() {
        if (this.level.f_46443_) {
            MarkDrawingContext.storeContext(this);
            return;
        }
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            List<MarkSymbol> unlockedSymbols = SymbolUnlocking.getUnlockedSymbols(serverPlayer);
            if (unlockedSymbols.size() > 0) {
                Packets.sendToClient(new ClientboundSelectSymbolPacket(unlockedSymbols), serverPlayer);
            } else {
                this.player.m_5661_((Component)Lang.MESSAGE_NO_SYMBOLS_UNLOCKED.translate(new Object[0]).m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    public Mark createRegularMark(int color, boolean glowing) {
        return this.createMark(color, this.getInitialOrientation() == SymbolOrientation.CENTER ? MarkSymbol.CENTER : MarkSymbol.ARROW, glowing);
    }

    public Mark createMark(int color, MarkSymbol symbol, boolean glowing) {
        Direction face = this.getMarkFacing();
        MarkSymbol.OrientationBehavior rotBehavior = symbol.getOrientationBehavior();
        SymbolOrientation orientation = rotBehavior == MarkSymbol.OrientationBehavior.FULL ? this.initialOrientation : (rotBehavior == MarkSymbol.OrientationBehavior.CARDINAL ? SymbolOrientation.fromClickLocationCardinal(this.hitResult.m_82450_(), face) : (rotBehavior == MarkSymbol.OrientationBehavior.UP_DOWN_CARDINAL && (face == Direction.UP || face == Direction.DOWN) ? SymbolOrientation.fromRotation(this.player.m_6350_().m_122424_().m_122416_() * 90) : symbol.getDefaultOrientation()));
        return new Mark(face, color, symbol, orientation, glowing);
    }

    public boolean hasExistingMark() {
        return this.level.m_8055_(this.hitResult.m_82425_().m_121945_(this.getMarkFacing())).m_60734_() instanceof ChalkMarkBlock;
    }

    public boolean shouldMarkReplaceAnother(Mark mark) {
        BlockState oldMarkState = this.level.m_8055_(this.hitResult.m_82425_().m_121945_(this.getMarkFacing()));
        Block block = oldMarkState.m_60734_();
        if (!(block instanceof ChalkMarkBlock)) {
            return true;
        }
        ChalkMarkBlock markBlock = (ChalkMarkBlock)block;
        if (mark.color != ChalkColors.fromDyeColor(markBlock.getColor())) {
            return true;
        }
        if (mark.facing != oldMarkState.m_61143_((Property)ChalkMarkBlock.FACING)) {
            return true;
        }
        if (mark.symbol != oldMarkState.m_61143_(ChalkMarkBlock.SYMBOL)) {
            return true;
        }
        if (mark.orientation != oldMarkState.m_61143_(ChalkMarkBlock.ORIENTATION)) {
            return true;
        }
        return mark.glowing && (Boolean)oldMarkState.m_61143_((Property)ChalkMarkBlock.GLOWING) == false;
    }

    public boolean draw(Mark mark) {
        ItemStack drawingItemstack = this.player.m_21120_(this.drawingHand);
        return MarkDrawHelper.draw(this.player, this.level, this.getMarkBlockPos(), mark.createBlockState(drawingItemstack), mark.color, this.drawingHand);
    }

    private static boolean canBeDrawnOn(BlockPos pos, Direction face, Level level) {
        BlockState blockStateAtPos = level.m_8055_(pos);
        BlockState markPosState = level.m_8055_(pos.m_121945_(face));
        return (markPosState.m_60795_() || markPosState.m_60734_() instanceof ChalkMarkBlock) && Block.m_49918_((VoxelShape)blockStateAtPos.m_60812_((BlockGetter)level, pos), (Direction)face) && !blockStateAtPos.m_204336_(Chalk.Tags.Blocks.CHALK_CANNOT_DRAW_ON);
    }
}

