/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.biome;

import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.phys.Vec3;

public class BiomeSampler {
    private static final double[] GAUSSIAN_SAMPLE_KERNEL = new double[]{0.0, 1.0, 4.0, 6.0, 4.0, 1.0, 0.0};

    public static Vec3 sampleBiomesVec3(LevelReader level, Vec3 pos, Vec3Fetcher vec3Fetcher) {
        return BiomeSampler.sampleBiomesVec3Quart(level, pos.m_82492_(2.0, 2.0, 2.0).m_82490_(0.25), vec3Fetcher);
    }

    public static float sampleBiomesFloat(LevelReader level, Vec3 pos, FloatFetcher floatFetcher) {
        return BiomeSampler.sampleBiomesFloatQuart(level, pos.m_82492_(2.0, 2.0, 2.0).m_82490_(0.25), floatFetcher);
    }

    public static Vec3 sampleBiomesVec3Quart(LevelReader level, Vec3 quartPos, Vec3Fetcher vec3Fetcher) {
        int i = Mth.m_14107_((double)quartPos.m_7096_());
        int j = Mth.m_14107_((double)quartPos.m_7098_());
        int k = Mth.m_14107_((double)quartPos.m_7094_());
        double d0 = quartPos.m_7096_() - (double)i;
        double d1 = quartPos.m_7098_() - (double)j;
        double d2 = quartPos.m_7094_() - (double)k;
        double d3 = 0.0;
        Vec3 vec3 = Vec3.f_82478_;
        BiomeManager biomeManager = level.m_7062_();
        for (int l = 0; l < 6; ++l) {
            double d4 = Mth.m_14139_((double)d0, (double)GAUSSIAN_SAMPLE_KERNEL[l + 1], (double)GAUSSIAN_SAMPLE_KERNEL[l]);
            int i1 = i - 2 + l;
            for (int j1 = 0; j1 < 6; ++j1) {
                double d5 = Mth.m_14139_((double)d1, (double)GAUSSIAN_SAMPLE_KERNEL[j1 + 1], (double)GAUSSIAN_SAMPLE_KERNEL[j1]);
                int k1 = j - 2 + j1;
                for (int l1 = 0; l1 < 6; ++l1) {
                    double d6 = Mth.m_14139_((double)d2, (double)GAUSSIAN_SAMPLE_KERNEL[l1 + 1], (double)GAUSSIAN_SAMPLE_KERNEL[l1]);
                    int i2 = k - 2 + l1;
                    double d7 = d4 * d5 * d6;
                    d3 += d7;
                    vec3 = vec3.m_82549_(vec3Fetcher.fetch((Holder<Biome>)biomeManager.m_204210_(i1, k1, i2)).m_82490_(d7));
                }
            }
        }
        return vec3.m_82490_(1.0 / d3);
    }

    public static float sampleBiomesFloatQuart(LevelReader level, Vec3 quartPos, FloatFetcher floatFetcher) {
        int i = Mth.m_14107_((double)quartPos.m_7096_());
        int j = Mth.m_14107_((double)quartPos.m_7098_());
        int k = Mth.m_14107_((double)quartPos.m_7094_());
        double d0 = quartPos.m_7096_() - (double)i;
        double d1 = quartPos.m_7098_() - (double)j;
        double d2 = quartPos.m_7094_() - (double)k;
        double d3 = 0.0;
        float f = 0.0f;
        BiomeManager biomeManager = level.m_7062_();
        for (int l = 0; l < 6; ++l) {
            double d4 = Mth.m_14139_((double)d0, (double)GAUSSIAN_SAMPLE_KERNEL[l + 1], (double)GAUSSIAN_SAMPLE_KERNEL[l]);
            int i1 = i - 2 + l;
            for (int j1 = 0; j1 < 6; ++j1) {
                double d5 = Mth.m_14139_((double)d1, (double)GAUSSIAN_SAMPLE_KERNEL[j1 + 1], (double)GAUSSIAN_SAMPLE_KERNEL[j1]);
                int k1 = j - 2 + j1;
                for (int l1 = 0; l1 < 6; ++l1) {
                    double d6 = Mth.m_14139_((double)d2, (double)GAUSSIAN_SAMPLE_KERNEL[l1 + 1], (double)GAUSSIAN_SAMPLE_KERNEL[l1]);
                    int i2 = k - 2 + l1;
                    double d7 = d4 * d5 * d6;
                    d3 += d7;
                    f = (float)((double)f + (double)floatFetcher.fetch((Holder<Biome>)biomeManager.m_204210_(i1, k1, i2)) * d7);
                }
            }
        }
        return f / (float)d3;
    }

    @FunctionalInterface
    public static interface Vec3Fetcher {
        public Vec3 fetch(Holder<Biome> var1);
    }

    @FunctionalInterface
    public static interface FloatFetcher {
        public float fetch(Holder<Biome> var1);
    }
}

