/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.GumWormEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class GumWormLeapRandomlyGoal
extends Goal {
    private final GumWormEntity entity;
    private double x;
    private double y;
    private double z;
    private boolean hasLept = false;
    private float leapRot;
    private int leapFor;
    private int maxLeapTime;
    private float leapHeight;
    private float leapRange;

    public GumWormLeapRandomlyGoal(GumWormEntity worm) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = worm;
    }

    public boolean m_8036_() {
        LivingEntity attackTarget = this.entity.m_5448_();
        if (!this.entity.m_5830_() || this.entity.isLeaping() || this.entity.isRidingMode() || attackTarget != null && attackTarget.m_6084_() || this.entity.m_217043_().m_188503_(1) != 0) {
            return false;
        }
        Vec3 target = this.findLeapFromPosition();
        if (target == null) {
            return false;
        }
        this.x = target.f_82479_;
        this.y = target.f_82480_;
        this.z = target.f_82481_;
        return true;
    }

    public void m_8056_() {
        this.hasLept = false;
        this.maxLeapTime = 15 + this.entity.m_217043_().m_188503_(10);
        this.leapFor = 0;
        this.leapHeight = 0.4f + this.entity.m_217043_().m_188501_() * 0.25f;
        this.leapRange = 0.3f + this.entity.m_217043_().m_188501_() * 0.2f;
    }

    public void m_8041_() {
        this.entity.m_21573_().m_26573_();
        LivingEntity attackTarget = this.entity.m_5448_();
        if (attackTarget == null || !attackTarget.m_6084_()) {
            this.entity.setLeaping(false);
        }
    }

    public boolean m_8045_() {
        if (this.hasLept) {
            return this.leapFor > 0 || !this.entity.m_5830_();
        }
        return this.entity.m_21573_().m_26572_() && !this.entity.m_21573_().m_26577_() && !this.hasLept && !this.entity.isRidingMode();
    }

    public void m_8037_() {
        if (this.hasLept) {
            this.entity.m_21573_().m_26573_();
            this.entity.setLeaping(true);
            float forceDown = (float)this.leapFor / (float)this.maxLeapTime < 0.5f ? -0.45f : 0.0f;
            Vec3 leapDelta = new Vec3(0.0, Math.sin((double)((float)this.leapFor / (float)this.maxLeapTime) * Math.PI) * (double)this.leapHeight + (double)forceDown, (double)this.leapRange).m_82524_((float)(-Math.toRadians(this.leapRot)));
            this.entity.m_20256_(this.entity.m_20184_().m_82549_(leapDelta));
            this.entity.m_146922_(this.leapRot);
            if (this.leapFor > 0) {
                --this.leapFor;
            }
        } else {
            this.entity.m_21573_().m_26519_(this.x, this.y, this.z, (double)1.3f);
            if (this.entity.m_20275_(this.x, this.y, this.z) < 18.0) {
                this.hasLept = true;
                this.leapFor = this.maxLeapTime;
                this.leapRot = this.entity.m_146908_();
                this.entity.m_21573_().m_26573_();
                this.entity.m_20256_(this.entity.m_20184_().m_82520_(0.0, (double)0.4f, 0.0));
            }
        }
    }

    private Vec3 findLeapFromPosition() {
        BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos checkBefore = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 20; ++i) {
            check.m_122193_((Vec3i)this.entity.m_20183_());
            check.m_122184_(this.entity.m_217043_().m_188503_(32) - 16, this.entity.m_217043_().m_188503_(32) - 16, this.entity.m_217043_().m_188503_(32) - 16);
            checkBefore.m_122190_((Vec3i)check);
            if (check.m_123342_() < this.entity.m_9236_().m_141937_() || !this.entity.m_9236_().m_46749_((BlockPos)check)) break;
            while (this.entity.m_9236_().m_46859_((BlockPos)check) && check.m_123342_() > this.entity.m_9236_().m_141937_()) {
                checkBefore.m_122190_((Vec3i)check);
                check.m_122184_(0, -1, 0);
            }
            while (!this.entity.m_9236_().m_46859_((BlockPos)check) && check.m_123342_() < this.entity.m_9236_().m_151558_()) {
                checkBefore.m_122190_((Vec3i)check);
                check.m_122184_(0, 1, 0);
            }
            while (check.m_123342_() < this.entity.m_9236_().m_141937_() + 1) {
                check.m_122184_(0, 1, 0);
            }
            if (!this.entity.m_9236_().m_46859_((BlockPos)check)) continue;
            return Vec3.m_82512_((Vec3i)check.m_7949_().m_7495_());
        }
        return null;
    }
}

