/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.emissivity.client.renderer;

import com.aetherteam.emissivity.client.renderer.EmissivityModelLayers;
import com.aetherteam.emissivity.client.renderer.player.layer.EmissiveArmorLayer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aether_emissivity", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class EmissivityRenderers {
    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        LayerDefinition outer = LayerDefinition.m_171565_((MeshDefinition)HumanoidArmorModel.m_269566_((CubeDeformation)new CubeDeformation(1.025f)), (int)64, (int)32);
        LayerDefinition inner = LayerDefinition.m_171565_((MeshDefinition)HumanoidArmorModel.m_269566_((CubeDeformation)new CubeDeformation(0.525f)), (int)64, (int)32);
        event.registerLayerDefinition(EmissivityModelLayers.PLAYER_INNER_ARMOR_EMISSIVE, () -> inner);
        event.registerLayerDefinition(EmissivityModelLayers.PLAYER_OUTER_ARMOR_EMISSIVE, () -> outer);
        event.registerLayerDefinition(EmissivityModelLayers.PLAYER_SLIM_INNER_ARMOR_EMISSIVE, () -> inner);
        event.registerLayerDefinition(EmissivityModelLayers.PLAYER_SLIM_OUTER_ARMOR_EMISSIVE, () -> outer);
        event.registerLayerDefinition(EmissivityModelLayers.ENTITY_INNER_ARMOR_EMISSIVE, () -> inner);
        event.registerLayerDefinition(EmissivityModelLayers.ENTITY_OUTER_ARMOR_EMISSIVE, () -> outer);
    }

    @SubscribeEvent
    public static void addPlayerLayers(EntityRenderersEvent.AddLayers event) {
        String[] types;
        EntityModelSet entityModelSet = event.getEntityModels();
        for (String type : types = new String[]{"default", "slim"}) {
            PlayerRenderer playerRenderer = (PlayerRenderer)event.getSkin(type);
            if (playerRenderer == null) continue;
            playerRenderer.m_115326_(new EmissiveArmorLayer(playerRenderer, new HumanoidArmorModel(entityModelSet.m_171103_(type.equals("slim") ? EmissivityModelLayers.PLAYER_SLIM_INNER_ARMOR_EMISSIVE : EmissivityModelLayers.PLAYER_INNER_ARMOR_EMISSIVE)), new HumanoidArmorModel(entityModelSet.m_171103_(type.equals("slim") ? EmissivityModelLayers.PLAYER_SLIM_OUTER_ARMOR_EMISSIVE : EmissivityModelLayers.PLAYER_OUTER_ARMOR_EMISSIVE)), Minecraft.m_91087_().m_91304_()));
        }
        List<EntityType> entities = List.of(EntityType.f_20501_, EntityType.f_20530_, EntityType.f_20458_, EntityType.f_20524_, EntityType.f_20481_, EntityType.f_20511_, EntityType.f_20531_, EntityType.f_20529_);
        for (EntityType entityType : entities) {
            LivingEntityRenderer renderer = event.getRenderer(entityType);
            if (renderer == null) continue;
            renderer.m_115326_(new EmissiveArmorLayer(renderer, new HumanoidArmorModel(entityModelSet.m_171103_(EmissivityModelLayers.ENTITY_INNER_ARMOR_EMISSIVE)), new HumanoidArmorModel(entityModelSet.m_171103_(EmissivityModelLayers.ENTITY_OUTER_ARMOR_EMISSIVE)), Minecraft.m_91087_().m_91304_()));
        }
    }
}

