/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.entity;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbquests.block.entity.FTBQuestsBlockEntities;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class DetectorBlockEntity
extends BlockEntity {
    private long objectId = 0L;
    private int radius = 8;

    public DetectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)FTBQuestsBlockEntities.DETECTOR.get(), blockPos, blockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.objectId = QuestObjectBase.parseCodeString(tag.m_128461_("Object"));
        this.radius = tag.m_128451_("Radius");
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128359_("Object", QuestObjectBase.getCodeString(this.objectId));
        tag.m_128405_("Radius", this.radius);
    }

    public void update(String idStr) {
        this.objectId = ServerQuestFile.INSTANCE.getID(idStr);
    }

    private static boolean isRealPlayer(ServerPlayer player) {
        return !PlayerHooks.isFake((Player)player);
    }

    public void onPowered(Level level, BlockPos pos) {
        QuestObjectBase qo = ServerQuestFile.INSTANCE.getBase(this.objectId);
        if (qo != null) {
            AABB box = new AABB(pos).m_82400_((double)this.radius);
            for (ServerPlayer player : level.m_6443_(ServerPlayer.class, box, DetectorBlockEntity::isRealPlayer)) {
                TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)player);
                qo.forceProgressRaw(data, new ProgressChange(ServerQuestFile.INSTANCE, qo, player.m_20148_()).setReset(false).withNotifications());
            }
        }
    }
}

