/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.mixin.customization;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.placement.PlacementSystem;
import snownee.kiwi.customization.shape.BlockShapeType;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateMixin {
    @Shadow
    public abstract Block m_60734_();

    @Shadow
    protected abstract BlockState m_7160_();

    @Inject(method={"canSurvive"}, at={@At(value="HEAD")}, cancellable=true)
    private void kiwi$canSurvive(LevelReader pLevel, BlockPos pPos, CallbackInfoReturnable<Boolean> cir) {
        KBlockSettings settings = KBlockSettings.of(this.m_60734_());
        if (settings != null && settings.canSurviveHandler != null) {
            cir.setReturnValue((Object)settings.canSurviveHandler.canSurvive(this.m_7160_(), pLevel, pPos));
        }
    }

    @Inject(method={"updateShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void kiwi$checkCanSurvive(Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos, CallbackInfoReturnable<BlockState> cir) {
        KBlockSettings settings = KBlockSettings.of(this.m_60734_());
        if (settings != null && settings.canSurviveHandler != null && settings.canSurviveHandler.isSensitiveSide(this.m_7160_(), pDirection) && !settings.canSurviveHandler.canSurvive(this.m_7160_(), (LevelReader)pLevel, pPos)) {
            cir.setReturnValue((Object)Blocks.f_50016_.m_49966_());
        }
    }

    @Inject(method={"updateShape"}, at={@At(value="RETURN")}, cancellable=true)
    private void kiwi$updateShape(Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos, CallbackInfoReturnable<BlockState> cir) {
        if (!((BlockState)cir.getReturnValue()).m_60713_(this.m_60734_())) {
            return;
        }
        KBlockSettings settings = KBlockSettings.of(this.m_60734_());
        if (settings != null) {
            cir.setReturnValue((Object)settings.updateShape((BlockState)cir.getReturnValue(), pDirection, pNeighborState, pLevel, pPos, pNeighborPos));
        }
    }

    @Inject(method={"canBeReplaced(Lnet/minecraft/world/item/context/BlockPlaceContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void kiwi$canBeReplaced(BlockPlaceContext pUseContext, CallbackInfoReturnable<Boolean> cir) {
        KBlockSettings settings = KBlockSettings.of(this.m_60734_());
        if (settings == null) {
            return;
        }
        Boolean triState = settings.canBeReplaced(this.m_7160_(), pUseContext);
        if (triState != null) {
            cir.setReturnValue((Object)triState);
        }
    }

    @WrapOperation(method={"onRemove"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;onRemove(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V")})
    private void kiwi$onRemove(Block block, BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean pMovedByPiston, Operation<Void> original) {
        original.call(new Object[]{block, oldState, level, pos, newState, pMovedByPiston});
        try {
            PlacementSystem.onBlockRemoved(level, pos, oldState, newState);
        }
        catch (Throwable t) {
            Kiwi.LOGGER.error("Failed to handle placement for %s".formatted(oldState), t);
        }
    }

    @WrapOperation(method={"getShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;getShape(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;")})
    private VoxelShape kiwi$getShape(Block instance, BlockState blockState, BlockGetter blockGetter, BlockPos pos, CollisionContext context, Operation<VoxelShape> original) {
        KBlockSettings settings = KBlockSettings.of(this.m_60734_());
        if (settings != null && settings.getShape(BlockShapeType.MAIN) != null) {
            try {
                return settings.getShape(BlockShapeType.MAIN).getShape(blockState, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (VoxelShape)original.call(new Object[]{instance, blockState, blockGetter, pos, context});
    }

    @WrapOperation(method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;getCollisionShape(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;")})
    private VoxelShape kiwi$getCollisionShape(Block instance, BlockState blockState, BlockGetter blockGetter, BlockPos pos, CollisionContext context, Operation<VoxelShape> original) {
        KBlockSettings settings = KBlockSettings.of(this.m_60734_());
        if (settings != null && settings.getShape(BlockShapeType.COLLISION) != null) {
            try {
                return settings.getShape(BlockShapeType.COLLISION).getShape(blockState, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (VoxelShape)original.call(new Object[]{instance, blockState, blockGetter, pos, context});
    }

    @WrapOperation(method={"getInteractionShape"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;getInteractionShape(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/phys/shapes/VoxelShape;")})
    private VoxelShape kiwi$getInteractionShape(Block instance, BlockState blockState, BlockGetter blockGetter, BlockPos pos, Operation<VoxelShape> original) {
        KBlockSettings settings = KBlockSettings.of(this.m_60734_());
        if (settings != null && settings.getShape(BlockShapeType.INTERACTION) != null) {
            try {
                return settings.getShape(BlockShapeType.INTERACTION).getShape(blockState, CollisionContext.m_82749_());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (VoxelShape)original.call(new Object[]{instance, blockState, blockGetter, pos});
    }
}

