/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface.init.forge;

import com.google.common.io.Resources;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import lain.mods.peacefulsurface.api.PeaceAPI;
import lain.mods.peacefulsurface.impl.JsonRule;
import lain.mods.peacefulsurface.impl.forge.ForgeEntityObj;
import lain.mods.peacefulsurface.impl.forge.ForgeWorldObj;
import lain.mods.peacefulsurface.init.forge.ForgePeacefulSurface;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

enum Proxy {
    INSTANCE;

    Logger logger = LogManager.getLogger(ForgePeacefulSurface.class);

    void handleCheckSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getSpawnType() != MobSpawnType.NATURAL || !PeaceAPI.filterEntity(ForgeEntityObj.get((Entity)event.getEntity()), ForgeWorldObj.get(event.getLevel().m_6018_()), Mth.m_14107_((double)event.getX()), Mth.m_14107_((double)event.getY()), Mth.m_14107_((double)event.getZ()))) {
            return;
        }
        event.setSpawnCancelled(true);
        event.setCanceled(true);
    }

    void handleRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reloadpeace").requires(source -> source.m_6761_(3))).executes(context -> {
            ((BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER)).execute(() -> {
                this.reloadRules();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.reloadpeace.done"), true);
            });
            return 0;
        }));
    }

    void init() {
        this.reloadRules();
        MinecraftForge.EVENT_BUS.addListener(this::handleCheckSpawn);
        MinecraftForge.EVENT_BUS.addListener(this::handleRegisterCommands);
    }

    void reloadRules() {
        try {
            this.logger.info("[PeacefulSurface] Loading filters...");
            PeaceAPI.clearFilters();
            File dir = Paths.get(".", "config", "PeacefulSurface_Rules").toFile();
            if (!dir.exists() && dir.mkdirs()) {
                try {
                    this.logger.info("[PeacefulSurface] Writing DefaultRule...");
                    FileUtils.copyURLToFile((URL)Resources.getResource((String)"/DefaultRule.json"), (File)new File(dir, "DefaultRule.json"));
                    this.logger.info("[PeacefulSurface] Successfully wrote DefaultRule.");
                }
                catch (IOException e) {
                    this.logger.error("[PeacefulSurface] Failed to write DefaultRule.", (Throwable)e);
                }
            }
            JsonRule.fromDirectory(dir).forEach(PeaceAPI::addFilter);
            PeaceAPI.notifyReloadListeners();
            this.logger.info("[PeacefulSurface] Loaded {} filter{}.", (Object)PeaceAPI.countFilters(), (Object)(PeaceAPI.countFilters() == 1 ? "" : "s"));
        }
        catch (Throwable t) {
            this.logger.error("[PeacefulSurface] Failed to load filters.", t);
            PeaceAPI.clearFilters();
        }
    }
}

