/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface.impl.forge;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.api.ECLunarEventTags;
import corgitaco.enhancedcelestials.core.EnhancedCelestialsContext;
import corgitaco.enhancedcelestials.lunarevent.LunarForecast;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lain.mods.peacefulsurface.api.interfaces.IWorldObj;
import lain.mods.peacefulsurface.init.forge.ForgePeacefulSurface;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.fml.ModList;

public class ForgeWorldObj
implements IWorldObj {
    private static final ForgeWorldObj dummy = new ForgeWorldObj(){
        {
            this.w = new WeakReference<Object>(null);
            this.name = "[Dummy]";
        }
    };
    private static final LoadingCache<ServerLevel, ForgeWorldObj> cache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<ServerLevel, ForgeWorldObj>(){

        public ForgeWorldObj load(ServerLevel key) throws Exception {
            try {
                ForgeWorldObj obj = new ForgeWorldObj();
                obj.w = new WeakReference<ServerLevel>(key);
                obj.name = key.m_46472_().m_135782_().toString();
                return obj;
            }
            catch (Throwable t) {
                return dummy;
            }
        }
    });
    private static final AtomicBoolean failedCompat_BloodMoon_EnhancedCelestials = new AtomicBoolean(!ModList.get().isLoaded("enhancedcelestials"));
    private static final AtomicBoolean failedCompat_LunarName_EnhancedCelestials = new AtomicBoolean(!ModList.get().isLoaded("enhancedcelestials"));
    WeakReference<ServerLevel> w;
    String name;

    private ForgeWorldObj() {
    }

    public static ForgeWorldObj get(ServerLevel world) {
        if (world == null) {
            return dummy;
        }
        return (ForgeWorldObj)cache.getUnchecked((Object)world);
    }

    @Override
    public String getBiomeName(int x, int y, int z) {
        ServerLevel o = (ServerLevel)this.w.get();
        if (o == null) {
            return "UNKNOWN";
        }
        return o.m_204166_(new BlockPos(x, y, z)).toString();
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        ServerLevel o = (ServerLevel)this.w.get();
        if (o == null) {
            return 0;
        }
        return o.m_46470_() ? o.m_46849_(new BlockPos(x, y, z), 10) : o.m_46803_(new BlockPos(x, y, z));
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        ServerLevel o = (ServerLevel)this.w.get();
        if (o == null) {
            return 0;
        }
        return o.m_45517_(LightLayer.BLOCK, new BlockPos(x, y, z));
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        ServerLevel o = (ServerLevel)this.w.get();
        if (o == null) {
            return 0;
        }
        return o.m_45517_(LightLayer.SKY, new BlockPos(x, y, z)) - (o.m_46470_() ? 10 : o.m_7445_());
    }

    @Override
    public int getMoonPhase() {
        ServerLevel o = (ServerLevel)this.w.get();
        if (o == null) {
            return 0;
        }
        return o.m_6042_().m_63936_(o.m_8044_());
    }

    @Override
    public int getDifficulty() {
        ServerLevel o = (ServerLevel)this.w.get();
        if (o == null) {
            return -1;
        }
        return o.m_46791_().m_19028_();
    }

    @Override
    public String getWorldName() {
        return this.name;
    }

    @Override
    public String getLunarName() {
        ServerLevel o = (ServerLevel)this.w.get();
        if (o == null) {
            return "";
        }
        if (!failedCompat_LunarName_EnhancedCelestials.get()) {
            try {
                return Optional.ofNullable(((EnhancedCelestialsWorldData)o).getLunarContext()).map(EnhancedCelestialsContext::getLunarForecast).map(LunarForecast::currentLunarEvent).map(lunarEventHolder -> lunarEventHolder.m_203543_().map(ResourceKey::m_135782_).map(ResourceLocation::toString).orElse("")).orElse("");
            }
            catch (Throwable t) {
                ForgePeacefulSurface.getLogger().error("error getting LunarName", t);
                failedCompat_LunarName_EnhancedCelestials.set(true);
            }
        }
        return "";
    }

    @Override
    public boolean isBloodMoon() {
        ServerLevel o = (ServerLevel)this.w.get();
        if (o == null) {
            return false;
        }
        if (!failedCompat_BloodMoon_EnhancedCelestials.get()) {
            try {
                return Optional.ofNullable(((EnhancedCelestialsWorldData)o).getLunarContext()).map(EnhancedCelestialsContext::getLunarForecast).map(LunarForecast::currentLunarEvent).map(lunarEventHolder -> {
                    if (lunarEventHolder.m_203656_(ECLunarEventTags.BLOOD_MOON)) {
                        return Boolean.TRUE;
                    }
                    return lunarEventHolder.m_203543_().map(ResourceKey::m_135782_).map(ResourceLocation::toString).map(location -> {
                        if ("enhancedcelestials:blood_moon".equals(location) || "enhancedcelestials:super_blood_moon".equals(location)) {
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }).orElse(Boolean.FALSE);
                }).orElse(Boolean.FALSE) == Boolean.TRUE;
            }
            catch (Throwable t) {
                ForgePeacefulSurface.getLogger().error("error checking BloodMoon", t);
                failedCompat_BloodMoon_EnhancedCelestials.set(true);
            }
        }
        return false;
    }

    @Override
    public boolean isDayTime() {
        ServerLevel o = (ServerLevel)this.w.get();
        if (o == null) {
            return false;
        }
        return o.m_46461_();
    }

    @Override
    public boolean isRaining() {
        ServerLevel o = (ServerLevel)this.w.get();
        if (o == null) {
            return false;
        }
        return o.m_46471_();
    }

    @Override
    public boolean isThundering() {
        ServerLevel o = (ServerLevel)this.w.get();
        if (o == null) {
            return false;
        }
        return o.m_46470_();
    }
}

