/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface.impl.forge;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import lain.mods.peacefulsurface.api.interfaces.IEntityObj;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public class ForgeEntityObj
implements IEntityObj {
    private static final ForgeEntityObj dummy = new ForgeEntityObj(){
        {
            this.name = "[Dummy]";
            this.animal = false;
            this.living = false;
            this.monster = false;
        }
    };
    private static final LoadingCache<EntityType<? extends Entity>, ForgeEntityObj> cache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<EntityType<? extends Entity>, ForgeEntityObj>(){

        public ForgeEntityObj load(EntityType<? extends Entity> key) throws Exception {
            try {
                ForgeEntityObj obj = new ForgeEntityObj();
                obj.name = EntityType.m_20613_(key).toString();
                obj.animal = key.m_20674_().m_21610_() && key.m_20674_().m_21609_();
                obj.living = key.m_20674_() != MobCategory.MISC;
                obj.monster = !key.m_20674_().m_21609_();
                return obj;
            }
            catch (Throwable t) {
                return dummy;
            }
        }
    });
    String name;
    boolean animal;
    boolean living;
    boolean monster;

    private ForgeEntityObj() {
    }

    public static ForgeEntityObj get(Entity entity) {
        if (entity == null) {
            return dummy;
        }
        return (ForgeEntityObj)cache.getUnchecked((Object)entity.m_6095_());
    }

    @Override
    public String getEntityName() {
        return this.name;
    }

    @Override
    public boolean isAnimal() {
        return this.animal;
    }

    @Override
    public boolean isLiving() {
        return this.living;
    }

    @Override
    public boolean isMonster() {
        return this.monster;
    }
}

