/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lain.mods.peacefulsurface.api.interfaces.IEntityObj;
import lain.mods.peacefulsurface.api.interfaces.IEntitySpawnFilter;
import lain.mods.peacefulsurface.api.interfaces.IWorldObj;

public class JsonRule
implements IEntitySpawnFilter {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public boolean Disabled;
    public boolean Living;
    public boolean Monster;
    public boolean Animal;
    public boolean UseMobFilter;
    public boolean UseDimensionFilter;
    public boolean UseBiomeFilter;
    public boolean UseLunarNameFilter;
    public boolean Checking_LightLevel;
    public boolean Checking_Altitude;
    public boolean Checking_BlockLight;
    public boolean Checking_SkyLight;
    public boolean Sunny;
    public boolean Raining;
    public boolean Thundering;
    public boolean Day;
    public boolean Night;
    public boolean InvertedMobFilter;
    public boolean InvertedDimensionFilter;
    public boolean InvertedBiomeFilter;
    public boolean InvertedLunarNameFilter;
    public boolean InvertedLightLevelChecking;
    public boolean InvertedAltitudeChecking;
    public boolean InvertedBlockLightChecking;
    public boolean InvertedSkyLightChecking;
    public String mobFilter = "";
    public String dimensionFilter = "";
    public String biomeFilter = "";
    public String lunarNameFilter = "";
    public int LightLevel;
    public int Altitude;
    public int BlockLight;
    public int SkyLight;
    public int MoonPhase;
    public int Difficulty;
    public boolean DisabledUnderBloodmoon;
    public boolean DisabledWhenSunny;
    public boolean DisabledWhenRaining;
    public boolean DisabledWhenThundering;
    public boolean DisabledWhenDay;
    public boolean DisabledWhenNight;
    private transient boolean valid = false;
    private transient Pattern _mobFilter;
    private transient Pattern _dimensionFilter;
    private transient Pattern _biomeFilter;
    private transient Pattern _lunarNameFilter;

    public static Collection<JsonRule> fromDirectory(File dir) throws IOException {
        return JsonRule.fromDirectory(dir, ignored -> true);
    }

    public static Collection<JsonRule> fromDirectory(File dir, Predicate<? super IOException> handler) throws IOException {
        ArrayList<JsonRule> list = new ArrayList<JsonRule>();
        String newLine = System.getProperty("line.separator");
        for (File file2 : dir.listFiles(file -> file.getName().toLowerCase().endsWith(".json"))) {
            try {
                list.add(JsonRule.fromJson(Files.lines(file2.toPath(), StandardCharsets.UTF_8).collect(Collectors.joining(newLine))));
            }
            catch (IOException e) {
                if (handler.test(e)) continue;
                throw e;
            }
        }
        return list;
    }

    public static JsonRule fromJson(String json) {
        return (JsonRule)gson.fromJson(json, JsonRule.class);
    }

    @Override
    public boolean enabled() {
        return !this.Disabled;
    }

    @Override
    public boolean filterEntity(IEntityObj entity, IWorldObj world, int x, int y, int z) {
        String lunarName;
        String biomeName;
        String dimensionName;
        this.validate();
        if (this.DisabledUnderBloodmoon && world.isBloodMoon()) {
            return false;
        }
        if (this.DisabledWhenSunny && !world.isRaining() && !world.isThundering()) {
            return false;
        }
        if (this.DisabledWhenRaining && world.isRaining()) {
            return false;
        }
        if (this.DisabledWhenThundering && world.isThundering()) {
            return false;
        }
        if (this.DisabledWhenDay && world.isDayTime()) {
            return false;
        }
        if (this.DisabledWhenNight && !world.isDayTime()) {
            return false;
        }
        if (this.MoonPhase != 0 && world.getMoonPhase() != this.MoonPhase - 1) {
            return false;
        }
        if (this.Difficulty != 0 && world.getDifficulty() != this.Difficulty - 1) {
            return false;
        }
        if (this.Living && !entity.isLiving()) {
            return false;
        }
        if (this.Monster && !entity.isMonster()) {
            return false;
        }
        if (this.Animal && !entity.isAnimal()) {
            return false;
        }
        String mobName = entity.getEntityName();
        if (mobName == null) {
            return false;
        }
        if (this.UseMobFilter && (this.InvertedMobFilter ? !this._mobFilter.matcher(mobName).lookingAt() : this._mobFilter.matcher(mobName).lookingAt())) {
            return false;
        }
        if (this.UseDimensionFilter && (this.InvertedDimensionFilter ? !this._dimensionFilter.matcher(dimensionName = world.getWorldName()).lookingAt() : this._dimensionFilter.matcher(dimensionName = world.getWorldName()).lookingAt())) {
            return false;
        }
        if (this.UseBiomeFilter && (this.InvertedBiomeFilter ? !this._biomeFilter.matcher(biomeName = world.getBiomeName(x, y, z)).lookingAt() : this._biomeFilter.matcher(biomeName = world.getBiomeName(x, y, z)).lookingAt())) {
            return false;
        }
        if (this.UseLunarNameFilter && (this.InvertedLunarNameFilter ? !this._lunarNameFilter.matcher(lunarName = world.getLunarName()).lookingAt() : this._lunarNameFilter.matcher(lunarName = world.getLunarName()).lookingAt())) {
            return false;
        }
        if (this.Checking_LightLevel) {
            int n = world.getLightLevel(x, y, z);
            if (this.InvertedLightLevelChecking ? n <= this.LightLevel : n > this.LightLevel) {
                return true;
            }
        }
        if (this.Checking_Altitude && (this.InvertedAltitudeChecking ? y <= this.Altitude : y > this.Altitude)) {
            return true;
        }
        if (this.Checking_BlockLight) {
            int n = world.getBlockLight(x, y, z);
            if (this.InvertedBlockLightChecking ? n <= this.BlockLight : n > this.BlockLight) {
                return true;
            }
        }
        if (this.Checking_SkyLight) {
            int n = world.getSkyLight(x, y, z);
            if (this.InvertedSkyLightChecking ? n <= this.SkyLight : n > this.SkyLight) {
                return true;
            }
        }
        if (this.Sunny && (world.isRaining() || world.isThundering())) {
            return true;
        }
        if (this.Raining && !world.isRaining()) {
            return true;
        }
        if (this.Thundering && !world.isThundering()) {
            return true;
        }
        if (this.Day && !world.isDayTime()) {
            return true;
        }
        return this.Night && world.isDayTime();
    }

    public void invalidate() {
        this.valid = false;
    }

    public void validate() {
        if (this.valid) {
            return;
        }
        if (this.MoonPhase < 0 || this.MoonPhase > 8) {
            this.MoonPhase = 0;
        }
        if (this.Difficulty < 0 || this.Difficulty > 4) {
            this.Difficulty = 0;
        }
        this._mobFilter = Pattern.compile(this.mobFilter);
        this._dimensionFilter = Pattern.compile(this.dimensionFilter);
        this._biomeFilter = Pattern.compile(this.biomeFilter);
        this._lunarNameFilter = Pattern.compile(this.lunarNameFilter);
        this.valid = true;
    }
}

