/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.dynamicpack;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import org.apache.logging.log4j.Logger;

public class ServerDynamicResourcesHandler
extends DynServerResourcesGenerator {
    public static final ServerDynamicResourcesHandler INSTANCE = new ServerDynamicResourcesHandler();

    public ServerDynamicResourcesHandler() {
        super(new DynamicDataPack(EveryCompat.res("generated_pack")));
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"minecraft"});
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"forge"});
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"everycomp"});
        if (PlatHelper.isModLoaded((String)"lolmcv")) {
            ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"lieonstudio"});
        }
    }

    public Logger getLogger() {
        return EveryCompat.LOGGER;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        if (!ECConfigs.GENERATE_DYNAMIC_SERVER.get().booleanValue()) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        ((DynamicDataPack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || ECConfigs.DEBUG_RESOURCES.get() != false);
        ArrayList tasks = new ArrayList();
        EveryCompat.forAllModules(m -> m.addDynamicServerResources(tasks::add));
        int minBatches = Runtime.getRuntime().availableProcessors();
        int maxBatches = tasks.size() / Runtime.getRuntime().availableProcessors();
        int batchSize = Math.max(minBatches, maxBatches);
        EveryCompat.LOGGER.info("Dynamic server resources generation tasks: {} in batches of: {}", (Object)tasks.size(), (Object)batchSize);
        for (int i = 0; i < tasks.size(); i += batchSize) {
            int end = Math.min(i + batchSize, tasks.size());
            List subList = tasks.subList(i, end);
            executor.accept((resourceManager, resourceSink) -> {
                for (ResourceGenTask task : subList) {
                    task.accept(resourceManager, resourceSink);
                }
            });
        }
        EveryCompat.LOGGER.info("Dynamic server assets generation took: {}", (Object)stopwatch.stop().toString());
    }

    public void addModToDynamicPack(String modId) {
        if (PlatHelper.isModLoaded((String)modId)) {
            ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{modId});
        }
    }
}

