/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.dynamicpack;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;

public class ClientDynamicResourcesHandler
extends DynClientResourcesGenerator {
    private static ClientDynamicResourcesHandler INSTANCE;
    private boolean firstInit = false;
    private final Map<BlockType, Palette> paletteCache = new ConcurrentHashMap<BlockType, Palette>();

    public static ClientDynamicResourcesHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClientDynamicResourcesHandler();
        }
        return INSTANCE;
    }

    public ClientDynamicResourcesHandler() {
        super(new DynamicTexturePack(EveryCompat.res("generated_pack")));
        if (PlatHelper.isModLoaded((String)"quark")) {
            ((DynamicTexturePack)this.getPack()).addNamespaces(new String[]{"quark"});
        }
        ((DynamicTexturePack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || ECConfigs.DEBUG_RESOURCES.get() != false);
    }

    public Logger getLogger() {
        return EveryCompat.LOGGER;
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        EveryCompat.forAllModules(m -> m.addTranslations(this, lang));
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        if (!this.firstInit) {
            SpriteHelper.addHardcodedSprites();
            this.firstInit = true;
        }
        if (!ECConfigs.GENERATE_DYNAMIC_CLIENT.get().booleanValue()) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        ((DynamicTexturePack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || ECConfigs.DEBUG_RESOURCES.get() != false);
        ArrayList tasks = new ArrayList();
        EveryCompat.forAllModules(m -> m.addDynamicClientResources(tasks::add));
        int minBatches = Runtime.getRuntime().availableProcessors();
        int maxBatches = tasks.size() / Runtime.getRuntime().availableProcessors();
        int batchSize = Math.max(minBatches, maxBatches);
        EveryCompat.LOGGER.info("Dynamic resources generation tasks: {} in batches of: {}", (Object)tasks.size(), (Object)batchSize);
        for (int i = 0; i < tasks.size(); i += batchSize) {
            int end = Math.min(i + batchSize, tasks.size());
            List subList = tasks.subList(i, end);
            executor.accept((resourceManager, resourceSink) -> {
                for (ResourceGenTask subtask : subList) {
                    subtask.accept(resourceManager, resourceSink);
                }
            });
        }
        EveryCompat.LOGGER.info("Dynamic client assets generation took: {}", (Object)stopwatch.stop().toString());
        this.paletteCache.clear();
    }

    public Palette getCachedBaseBlockTexturePalette(ResourceManager manager, BlockType baseType) {
        return this.paletteCache.computeIfAbsent(baseType, k -> {
            Palette palette;
            block8: {
                TextureImage oakPlanksTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)((Block)baseType.mainChild())));
                try {
                    palette = Palette.fromImage((TextureImage)oakPlanksTexture);
                    if (oakPlanksTexture == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (oakPlanksTexture != null) {
                            try {
                                oakPlanksTexture.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                oakPlanksTexture.close();
            }
            return palette;
        });
    }
}

