/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.bbb.block;

import com.starfish_studios.bbb.block.properties.BBBBlockStateProperties;
import com.starfish_studios.bbb.block.properties.TallDoorHalf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TallDoorBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<TallDoorHalf> HALVES = BBBBlockStateProperties.HALVES;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private final BlockSetType type;

    public TallDoorBlock(BlockBehaviour.Properties properties, BlockSetType blockSetType) {
        super(properties);
        this.type = blockSetType;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(HALVES, (Comparable)((Object)TallDoorHalf.LOWER)));
    }

    public BlockSetType type() {
        return this.type;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        boolean bl = (Boolean)blockState.m_61143_((Property)OPEN) == false;
        boolean bl2 = blockState.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return bl ? EAST_AABB : (bl2 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return bl ? SOUTH_AABB : (bl2 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return bl ? WEST_AABB : (bl2 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return bl ? NORTH_AABB : (bl2 ? WEST_AABB : EAST_AABB);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        TallDoorHalf half = (TallDoorHalf)((Object)blockState.m_61143_(HALVES));
        if (direction.m_122434_() == Direction.Axis.Y && (half == TallDoorHalf.LOWER == (direction == Direction.UP) || half == TallDoorHalf.MIDDLE == (direction == Direction.UP))) {
            if (blockState2.m_60713_((Block)this) && blockState2.m_61143_(HALVES) != half) {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)FACING, (Comparable)((Direction)blockState2.m_61143_((Property)FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)blockState2.m_61143_((Property)OPEN)))).m_61124_(HINGE, (Comparable)((DoorHingeSide)blockState2.m_61143_(HINGE)))).m_61124_((Property)POWERED, (Comparable)((Boolean)blockState2.m_61143_((Property)POWERED)));
            }
            return Blocks.f_50016_.m_49966_();
        }
        if (half == TallDoorHalf.LOWER && direction == Direction.DOWN && !blockState.m_60710_((LevelReader)levelAccessor, blockPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return switch (pathComputationType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)blockState.m_61143_((Property)OPEN);
            case PathComputationType.WATER -> false;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        if (blockPos.m_123342_() < level.m_151558_() - 2 && level.m_8055_(blockPos.m_7494_()).m_60629_(blockPlaceContext) && level.m_8055_(blockPos.m_6630_(2)).m_60629_(blockPlaceContext)) {
            boolean bl = level.m_276867_(blockPos) || level.m_276867_(blockPos.m_7494_()) || level.m_276867_(blockPos.m_6630_(2));
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_())).m_61124_(HINGE, (Comparable)this.getHinge(blockPlaceContext))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(bl))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(bl))).m_61124_(HALVES, (Comparable)((Object)TallDoorHalf.LOWER));
        }
        return null;
    }

    private DoorHingeSide getHinge(BlockPlaceContext blockPlaceContext) {
        boolean bl2;
        Level blockGetter = blockPlaceContext.m_43725_();
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Direction direction = blockPlaceContext.m_8125_();
        BlockPos blockPos2 = blockPos.m_7494_();
        Direction direction2 = direction.m_122428_();
        BlockPos blockPos3 = blockPos.m_121945_(direction2);
        BlockState blockState = blockGetter.m_8055_(blockPos3);
        BlockPos blockPos4 = blockPos2.m_121945_(direction2);
        BlockState blockState2 = blockGetter.m_8055_(blockPos4);
        Direction direction3 = direction.m_122427_();
        BlockPos blockPos5 = blockPos.m_121945_(direction3);
        BlockState blockState3 = blockGetter.m_8055_(blockPos5);
        BlockPos blockPos6 = blockPos2.m_121945_(direction3);
        BlockState blockState4 = blockGetter.m_8055_(blockPos6);
        int i = (blockState.m_60838_((BlockGetter)blockGetter, blockPos3) ? -1 : 0) + (blockState2.m_60838_((BlockGetter)blockGetter, blockPos4) ? -1 : 0) + (blockState3.m_60838_((BlockGetter)blockGetter, blockPos5) ? 1 : 0) + (blockState4.m_60838_((BlockGetter)blockGetter, blockPos6) ? 1 : 0);
        boolean bl = blockState.m_60713_((Block)this) && blockState.m_61143_(HALVES) == TallDoorHalf.LOWER;
        boolean bl3 = bl2 = blockState3.m_60713_((Block)this) && blockState3.m_61143_(HALVES) == TallDoorHalf.LOWER;
        if ((!bl || bl2) && i <= 0) {
            if ((!bl2 || bl) && i >= 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vec3 = blockPlaceContext.m_43720_();
                double d = vec3.f_82479_ - (double)blockPos.m_123341_();
                double e = vec3.f_82481_ - (double)blockPos.m_123343_();
                return !(j < 0 && e < 0.5 || j > 0 && e > 0.5 || k < 0 && d > 0.5 || k > 0 && d < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!this.type.f_278463_()) {
            return InteractionResult.PASS;
        }
        blockState = (BlockState)blockState.m_61122_((Property)OPEN);
        level.m_7731_(blockPos, blockState, 10);
        this.playSound((Entity)player, level, blockPos, (Boolean)blockState.m_61143_((Property)OPEN));
        level.m_142346_((Entity)player, this.isOpen(blockState) ? GameEvent.f_157796_ : GameEvent.f_157793_, blockPos);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private void playSound(@Nullable Entity entity, Level level, BlockPos blockPos, boolean bl) {
        level.m_245803_(entity, blockPos, bl ? this.type.f_271141_() : this.type.f_271502_(), SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    public boolean isOpen(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)OPEN);
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        boolean bl2;
        boolean bl3 = level.m_276867_(blockPos) || level.m_276867_(blockPos.m_121945_(blockState.m_61143_(HALVES) == TallDoorHalf.LOWER && blockState.m_61143_(HALVES) != TallDoorHalf.UPPER ? Direction.UP : Direction.DOWN)) ? true : (bl2 = false);
        if (!this.m_49966_().m_60713_(block) && bl2 != (Boolean)blockState.m_61143_((Property)POWERED)) {
            if (bl2 != (Boolean)blockState.m_61143_((Property)OPEN)) {
                this.playSound(null, level, blockPos, bl2);
                level.m_142346_(null, bl2 ? GameEvent.f_157796_ : GameEvent.f_157793_, blockPos);
            }
            level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(bl2))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(bl2)), 2);
        }
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return mirror == Mirror.NONE ? blockState : (BlockState)blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    public static boolean isWoodenDoor(Level level, BlockPos blockPos) {
        return TallDoorBlock.isWoodenDoor(level.m_8055_(blockPos));
    }

    public static boolean isWoodenDoor(BlockState blockState) {
        DoorBlock doorBlock;
        Block var2 = blockState.m_60734_();
        if (var2 instanceof DoorBlock && (doorBlock = (DoorBlock)var2).m_278711_().f_278463_()) {
            boolean var10000 = true;
            return var10000;
        }
        boolean var10000 = false;
        return var10000;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        BlockPos blockPos2 = blockPos.m_7494_();
        BlockPos blockPos3 = blockPos2.m_7494_();
        level.m_7731_(blockPos2, TallDoorBlock.copyWaterloggedFrom((LevelReader)level, blockPos2, (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(HALVES, (Comparable)((Object)TallDoorHalf.MIDDLE))).m_61124_((Property)FACING, (Comparable)((Direction)blockState.m_61143_((Property)FACING)))).m_61124_(HINGE, (Comparable)((DoorHingeSide)blockState.m_61143_(HINGE)))), 3);
        level.m_7731_(blockPos3, TallDoorBlock.copyWaterloggedFrom((LevelReader)level, blockPos3, (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(HALVES, (Comparable)((Object)TallDoorHalf.UPPER))).m_61124_((Property)FACING, (Comparable)((Direction)blockState.m_61143_((Property)FACING)))).m_61124_(HINGE, (Comparable)((DoorHingeSide)blockState.m_61143_(HINGE)))), 3);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        if (blockState.m_61143_(HALVES) != TallDoorHalf.UPPER && blockState.m_61143_(HALVES) != TallDoorHalf.MIDDLE) {
            return super.m_7898_(blockState, levelReader, blockPos);
        }
        if (blockState.m_61143_(HALVES) == TallDoorHalf.MIDDLE) {
            BlockState blockState2 = levelReader.m_8055_(blockPos.m_7495_());
            return blockState2.m_60713_((Block)this) && blockState2.m_61143_(HALVES) == TallDoorHalf.LOWER;
        }
        BlockState blockState2 = levelReader.m_8055_(blockPos.m_7495_());
        return blockState2.m_60713_((Block)this) && blockState2.m_61143_(HALVES) == TallDoorHalf.MIDDLE;
    }

    public static BlockState copyWaterloggedFrom(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return blockState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(levelReader.m_46801_(blockPos))) : blockState;
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                TallDoorBlock.preventCreativeDropFromBottomPart(level, blockPos, blockState, player);
            } else {
                TallDoorBlock.m_49881_((BlockState)blockState, (Level)level, (BlockPos)blockPos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public void m_6240_(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.m_6240_(level, player, blockPos, Blocks.f_50016_.m_49966_(), blockEntity, itemStack);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockPos blockPosBelow;
        BlockState stateBelow;
        TallDoorHalf halvesState = (TallDoorHalf)((Object)blockState.m_61143_(HALVES));
        if (halvesState == TallDoorHalf.UPPER && (stateBelow = level.m_8055_(blockPosBelow = blockPos.m_7495_())).m_60713_(blockState.m_60734_()) && stateBelow.m_61143_(HALVES) == TallDoorHalf.MIDDLE) {
            BlockState blockState3 = stateBelow.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(blockPosBelow, blockState3, 35);
            level.m_5898_(player, 2001, blockPosBelow, Block.m_49956_((BlockState)stateBelow));
            BlockPos blockPosBelow2 = blockPosBelow.m_7495_();
            BlockState stateBelow2 = level.m_8055_(blockPosBelow2);
            if (stateBelow2.m_60713_(blockState.m_60734_()) && stateBelow2.m_61143_(HALVES) == TallDoorHalf.LOWER) {
                BlockState blockState4 = stateBelow2.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
                level.m_7731_(blockPosBelow2, blockState4, 35);
                level.m_5898_(player, 2001, blockPosBelow2, Block.m_49956_((BlockState)stateBelow2));
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALVES, POWERED, HINGE, OPEN, FACING});
    }

    public long m_7799_(BlockState blockState, BlockPos blockPos) {
        return Mth.m_14130_((int)blockPos.m_123341_(), (int)blockPos.m_6625_(blockState.m_61143_(HALVES) == TallDoorHalf.MIDDLE ? 0 : 1).m_123342_(), (int)blockPos.m_123343_());
    }
}

