/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.forge.proxy;

import com.mojang.datafixers.util.Pair;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.client.ParagliderClientSettings;
import tictim.paraglider.command.ParagliderCommands;
import tictim.paraglider.config.PlayerStateMapConfig;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.ParagliderVillageStructures;
import tictim.paraglider.forge.ForgeParagliderNetwork;
import tictim.paraglider.forge.capability.PlayerMovementProvider;
import tictim.paraglider.forge.config.ForgePlayerStateMapConfig;
import tictim.paraglider.forge.contents.ConfigConditionSerializer;
import tictim.paraglider.impl.movement.NullMovement;
import tictim.paraglider.impl.movement.PlayerMovement;
import tictim.paraglider.impl.movement.PlayerStateConnectionMap;
import tictim.paraglider.impl.movement.PlayerStateMap;
import tictim.paraglider.impl.movement.PlayerStateMapLoader;
import tictim.paraglider.impl.movement.StaminaReductionLogicHandler;
import tictim.paraglider.impl.stamina.NullStamina;
import tictim.paraglider.impl.stamina.StaminaFactoryLoader;
import tictim.paraglider.impl.vessel.NullVesselContainer;
import tictim.paraglider.network.ParagliderNetwork;

public class CommonProxy {
    private final PlayerStateMapConfig stateMapConfig;
    private final PlayerStateConnectionMap connectionMap;

    public CommonProxy() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(e -> e.enqueueWork(() -> {
            CauldronInteraction.f_175607_.put(Contents.get().paraglider(), CauldronInteraction.f_175615_);
            CauldronInteraction.f_175607_.put(Contents.get().dekuLeaf(), CauldronInteraction.f_175615_);
        }));
        eventBus.addListener(e -> e.register(PlayerMovement.class));
        ParagliderAPI.setMovementSupplier(p -> {
            PlayerMovement m = PlayerMovementProvider.of((ICapabilityProvider)p);
            return m == null ? NullMovement.get() : m;
        });
        ParagliderAPI.setStaminaSupplier(p -> {
            PlayerMovement m = PlayerMovementProvider.of((ICapabilityProvider)p);
            return m == null ? NullStamina.get() : m.stamina();
        });
        ParagliderAPI.setVesselContainerSupplier(p -> {
            PlayerMovement m = PlayerMovementProvider.of((ICapabilityProvider)p);
            return m == null ? NullVesselContainer.get() : m.vessels();
        });
        Pair<PlayerStateMap, PlayerStateConnectionMap> pair = PlayerStateMapLoader.loadStates();
        this.stateMapConfig = new ForgePlayerStateMapConfig((PlayerStateMap)pair.getFirst());
        this.connectionMap = (PlayerStateConnectionMap)pair.getSecond();
        ParagliderAPI.setStaminaFactory(StaminaFactoryLoader.loadStaminaFactory());
        StaminaReductionLogicHandler.init();
        MinecraftForge.EVENT_BUS.addListener(this::onServerAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(e -> e.getDispatcher().register(ParagliderCommands.register()));
        MinecraftForge.EVENT_BUS.addListener(e -> {
            MinecraftServer server = e.getPlayerList().m_7873_();
            ParagliderUtils.checkBargainRecipes(server);
            ParagliderVillageStructures.addVillageStructures(server);
        });
        MinecraftForge.EVENT_BUS.addListener(e -> this.stateMapConfig.removeCallbacks());
        ForgeParagliderNetwork.init();
        for (ConfigConditionSerializer c : ConfigConditionSerializer.values()) {
            CraftingHelper.register((IConditionSerializer)c);
        }
    }

    protected void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        ParagliderVillageStructures.addVillageStructures(server);
        PlayerStateMapConfig stateMapConfig = this.stateMapConfig;
        stateMapConfig.removeCallbacks();
        stateMapConfig.reload();
        ParagliderUtils.printPlayerStates(stateMapConfig.stateMap(), this.getConnectionMap());
        stateMapConfig.addCallback(stateMap -> {
            ParagliderUtils.printPlayerStates(stateMap, this.getConnectionMap());
            ParagliderNetwork.get().syncStateMapToAll(server, (PlayerStateMap)stateMap);
        });
        ParagliderUtils.checkBargainRecipes(server);
    }

    @NotNull
    public ParagliderClientSettings getClientSettings() {
        throw new IllegalStateException("Trying to access client settings in server environment");
    }

    @NotNull
    public PlayerStateMap getStateMap() {
        return this.getLocalStateMap();
    }

    @NotNull
    public PlayerStateMap getLocalStateMap() {
        return this.stateMapConfig.stateMap();
    }

    @NotNull
    public PlayerStateConnectionMap getConnectionMap() {
        return this.connectionMap;
    }

    @NotNull
    public PlayerStateMapConfig getStateMapConfig() {
        return this.stateMapConfig;
    }

    public void setSyncedStateMap(@Nullable PlayerStateMap stateMap) {
        throw new IllegalStateException("Trying to access client side value in server environment");
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public KeyMapping getParagliderSettingsKey() {
        throw new AssertionError();
    }
}

