/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import dev.architectury.platform.Platform;
import java.util.List;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class EnigmaSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public EnigmaSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_()) {
            BlockState state;
            ServerLevel serverWorld = (ServerLevel)user.m_9236_();
            BlockState currentState = world.m_8055_(user.m_20183_().m_6630_(4).m_5484_(user.m_6374_(), 3));
            if (currentState == (state = Blocks.f_50016_.m_49966_())) {
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.DARK_SWORD_ATTACK_WITH_BLOOD_02.get(), user.m_5720_(), 0.4f, 0.8f);
                BattleStandardDarkEntity banner = (BattleStandardDarkEntity)((EntityType)EntityRegistry.BATTLESTANDARDDARK.get()).m_262496_(serverWorld, user.m_20183_().m_6630_(1).m_5484_(user.m_6374_(), 2), MobSpawnType.MOB_SUMMONED);
                if (banner != null) {
                    banner.m_20334_(0.0, -1.0, 0.0);
                    banner.ownerEntity = user;
                    banner.decayRate = (int)Config.getFloat("enigmaDecayRate", "UniqueEffects", ConfigDefaultValues.enigmaDecayRate);
                    banner.standardType = "enigma";
                    banner.m_6593_((Component)Component.m_237110_((String)"entity.simplyswords.battlestandard.name", (Object[])new Object[]{user.m_7755_()}));
                    banner.m_20340_(false);
                    banner.m_6842_(true);
                    banner.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.ELEMENTAL_VORTEX.get(), 900, 11, false, false, false));
                }
                user.m_36335_().m_41524_(this.m_7968_().m_41720_(), (int)Config.getFloat("enigmaCooldown", "UniqueEffects", ConfigDefaultValues.enigmaCooldown));
            }
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        if (entity.m_20096_() && Platform.isModLoaded((String)"bettercombat") && HelperMethods.isWalking(entity) && entity instanceof Player && (player = (Player)entity).m_21205_().m_150930_((Item)ItemsRegistry.ENIGMA.get())) {
            BlockState blockState = entity.m_20075_();
            BlockParticleOption particleEffect = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
            double bodyRadians = Math.toRadians(entity.m_213816_() + 180.0f);
            Vec3 backwardDirection = new Vec3(-Math.sin(bodyRadians), 0.0, Math.cos(bodyRadians)).m_82490_(1.1);
            double strafeRadians = Math.toRadians(entity.m_213816_() + 90.0f);
            Vec3 strafeDirection = new Vec3(-Math.sin(strafeRadians), 0.0, Math.cos(strafeRadians));
            Vec3 movementVector = entity.m_20184_();
            double strafeMagnitude = movementVector.m_82526_(strafeDirection.m_82541_());
            double pivotOffsetFactor = 3.0;
            Vec3 pivotOffset = strafeDirection.m_82490_(strafeMagnitude * pivotOffsetFactor);
            Vec3 adjustedBackwardDirection = backwardDirection.m_82546_(pivotOffset);
            Vec3 handPosOffset = entity.m_204034_(stack.m_41720_());
            double particleX = entity.m_20185_() + adjustedBackwardDirection.f_82479_ + handPosOffset.m_7096_();
            double particleY = entity.m_20186_() + handPosOffset.m_7098_();
            double particleZ = entity.m_20189_() + adjustedBackwardDirection.f_82481_ + handPosOffset.m_7094_();
            particleY = entity.m_20096_() ? entity.m_20186_() : particleY;
            world.m_7106_((ParticleOptions)particleEffect, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.enigmasworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.enigmasworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.enigmasworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.enigmasworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.enigmasworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.enigmasworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.enigmasworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.enigmasworditem.tooltip8").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

