/*
 * Decompiled with CFR 0.152.
 */
package me.platypus.bumblegum.common.ai;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class NewBeeWanderGoal
extends Goal {
    private static final int WANDER_THRESHOLD = 8;
    private final Bee bee;

    public NewBeeWanderGoal(Bee bee) {
        this.bee = bee;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.bee.m_21573_().m_26571_() && this.bee.m_217043_().m_188503_(10) == 0;
    }

    public boolean m_8045_() {
        return this.bee.m_21573_().m_26572_();
    }

    public void m_8056_() {
        Vec3 vec3 = this.findPos();
        if (vec3 != null) {
            this.bee.m_21573_().m_26536_(this.bee.m_21573_().m_7864_(BlockPos.m_274446_((Position)vec3), 1), 1.0);
        }
    }

    @Nullable
    private Vec3 findPos() {
        Vec3 vec3;
        if (this.bee.m_27872_() && !this.bee.m_27816_(this.bee.m_27855_(), 8)) {
            Vec3 vec31 = Vec3.m_82512_((Vec3i)this.bee.m_27855_());
            vec3 = vec31.m_82546_(this.bee.m_20182_()).m_82541_();
        } else {
            vec3 = this.bee.m_20252_(0.0f);
        }
        Vec3 vec = this.findPos(vec3);
        if (vec == null) {
            vec = this.findPos(vec3.m_82548_());
        }
        return vec;
    }

    private Vec3 findPos(Vec3 vec3) {
        Vec3 vec32 = HoverRandomPos.m_148465_((PathfinderMob)this.bee, (int)8, (int)7, (double)vec3.f_82479_, (double)vec3.f_82481_, (float)1.5707964f, (int)3, (int)1);
        if (vec32 == null) {
            vec32 = AirAndWaterRandomPos.m_148357_((PathfinderMob)this.bee, (int)8, (int)4, (int)-2, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)1.5707963705062866);
        }
        if (vec32 == null) {
            return null;
        }
        int worldHeight = this.bee.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING, (int)vec32.m_7096_(), (int)vec32.m_7094_());
        if (worldHeight <= this.bee.m_9236_().m_141937_()) {
            return null;
        }
        if (vec32.m_7098_() < (double)this.findLowestSectionHeightWithBlocks(this.bee.m_9236_(), (int)vec32.m_7096_(), (int)vec32.m_7094_())) {
            BlockPos pos = new BlockPos((int)vec32.m_7096_(), (int)vec32.m_7098_() + 8, (int)vec32.m_7094_());
            if (!GoalUtils.m_148461_((PathfinderMob)this.bee, (BlockPos)pos)) {
                return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            }
            return null;
        }
        return vec32;
    }

    private int findLowestSectionHeightWithBlocks(Level level, int x, int z) {
        LevelChunk chunk = this.bee.m_9236_().m_6325_(SectionPos.m_123171_((int)x), SectionPos.m_123171_((int)z));
        for (int i = 0; i < chunk.m_151559_(); ++i) {
            LevelChunkSection section = chunk.m_183278_(i);
            if (section.m_188008_()) continue;
            return SectionPos.m_123223_((int)chunk.m_151568_(i));
        }
        return level.m_151558_();
    }
}

