/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.storage.ServerStructurePackLoader;
import com.ldtteam.structurize.storage.StructurePackMeta;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class NotifyServerAboutStructurePacksMessage
implements IMessage {
    private final Map<String, Double> clientStructurePacks = new HashMap<String, Double>();

    public NotifyServerAboutStructurePacksMessage(FriendlyByteBuf buf) {
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.clientStructurePacks.put(buf.m_130136_(Short.MAX_VALUE), buf.readDouble());
        }
    }

    public NotifyServerAboutStructurePacksMessage(Collection<StructurePackMeta> clientStructurePacks) {
        for (StructurePackMeta pack : clientStructurePacks) {
            if (pack.isImmutable()) continue;
            this.clientStructurePacks.put(pack.getName(), pack.getVersion());
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.clientStructurePacks.size());
        for (Map.Entry<String, Double> packInfo : this.clientStructurePacks.entrySet()) {
            buf.m_130070_(packInfo.getKey());
            buf.writeDouble(packInfo.getValue().doubleValue());
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (isLogicalServer) {
            ServerStructurePackLoader.onClientSyncAttempt(this.clientStructurePacks, ctxIn.getSender());
        }
    }
}

