/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.config;

import com.google.common.collect.Lists;
import com.ldtteam.structurize.config.AbstractConfiguration;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfiguration
extends AbstractConfiguration {
    public final ForgeConfigSpec.BooleanValue ignoreSchematicsFromJar;
    public final ForgeConfigSpec.BooleanValue allowPlayerSchematics;
    public final ForgeConfigSpec.IntValue maxOperationsPerTick;
    public final ForgeConfigSpec.IntValue maxCachedChanges;
    public final ForgeConfigSpec.IntValue maxCachedSchematics;
    public final ForgeConfigSpec.IntValue maxBlocksChecked;
    public final ForgeConfigSpec.IntValue schematicBlockLimit;
    public final ForgeConfigSpec.ConfigValue<String> iteratorType;
    public final ForgeConfigSpec.ConfigValue<List<Integer>> updateStartPos;
    public final ForgeConfigSpec.ConfigValue<List<Integer>> updateEndPos;
    public final ForgeConfigSpec.BooleanValue teleportAllowed;
    public final ForgeConfigSpec.EnumValue<Direction> teleportBuildDirection;
    public final ForgeConfigSpec.IntValue teleportBuildDistance;
    public final ForgeConfigSpec.BooleanValue teleportSafety;

    protected ServerConfiguration(ForgeConfigSpec.Builder builder) {
        ServerConfiguration.createCategory(builder, "gameplay");
        this.ignoreSchematicsFromJar = ServerConfiguration.defineBoolean(builder, "ignoreSchematicsFromJar", false);
        this.allowPlayerSchematics = ServerConfiguration.defineBoolean(builder, "allowPlayerSchematics", true);
        this.maxOperationsPerTick = ServerConfiguration.defineInteger(builder, "maxOperationsPerTick", 1000, 0, 100000);
        this.maxCachedChanges = ServerConfiguration.defineInteger(builder, "maxCachedChanges", 50, 0, 250);
        this.maxCachedSchematics = ServerConfiguration.defineInteger(builder, "maxCachedSchematics", 100, 0, 100000);
        this.maxBlocksChecked = ServerConfiguration.defineInteger(builder, "maxBlocksChecked", 1000, 0, 100000);
        this.schematicBlockLimit = ServerConfiguration.defineInteger(builder, "schematicBlockLimit", 100000, 1000, 1000000);
        this.iteratorType = ServerConfiguration.defineString(builder, "iteratorType", "default");
        ServerConfiguration.swapToCategory(builder, "teleport");
        this.teleportAllowed = ServerConfiguration.defineBoolean(builder, "teleportAllowed", true);
        this.teleportBuildDirection = ServerConfiguration.defineEnum(builder, "teleportBuildDirection", Direction.SOUTH);
        this.teleportBuildDistance = ServerConfiguration.defineInteger(builder, "teleportBuildDistance", 3, 1, 16);
        this.teleportSafety = ServerConfiguration.defineBoolean(builder, "teleportSafety", true);
        ServerConfiguration.swapToCategory(builder, "update");
        this.updateStartPos = builder.define("start", (Object)Lists.newArrayList((Object[])new Integer[]{-10, -10}));
        this.updateEndPos = builder.define("end", (Object)Lists.newArrayList((Object[])new Integer[]{10, 10}));
        ServerConfiguration.finishCategory(builder);
    }
}

