/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.IOPool;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class WindowSwitchPack
extends AbstractWindowSkeleton {
    private static final String WINDOW_TAG_TOOL = ":gui/windowswitchpack.xml";
    private final Supplier<BOWindow> prevWindow;
    private final Predicate<StructurePackMeta> packPredicate;
    private ScrollingList packList;
    private List<StructurePackMeta> packMetas;
    private List<Object> sortedPacks = new ArrayList<Object>();
    private Future<List<StructurePackMeta>> packMetasFuture;
    private static int randomSeed = new Random().nextInt();

    public WindowSwitchPack(Supplier<BOWindow> prevWindow) {
        this(prevWindow, pack -> true);
    }

    public WindowSwitchPack(Supplier<BOWindow> prevWindow, Predicate<StructurePackMeta> packPredicate) {
        super("structurize:gui/windowswitchpack.xml");
        this.registerButton("select1", this::selectClicked);
        this.registerButton("select2", this::selectClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.prevWindow = prevWindow;
        this.packPredicate = packPredicate;
        ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).setHandler(input -> {
            String filter = ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).getText().toLowerCase(Locale.US);
            ArrayList<StructurePackMeta> list = new ArrayList<StructurePackMeta>();
            TreeMap<String, List> categories = new TreeMap<String, List>();
            for (StructurePackMeta structurePackMeta : this.packMetas) {
                if (!structurePackMeta.getName().toLowerCase(Locale.US).contains(filter)) continue;
                list.add(structurePackMeta);
                List catList = categories.getOrDefault(structurePackMeta.getOwner(), new ArrayList());
                catList.add(structurePackMeta);
                categories.put(structurePackMeta.getOwner(), catList);
            }
            this.sortedPacks.clear();
            for (Map.Entry entry : categories.entrySet()) {
                this.sortedPacks.add(entry.getKey());
                this.sortedPacks.add(entry.getKey());
                this.sortedPacks.addAll((Collection)entry.getValue());
                if (((List)entry.getValue()).size() % 2 == 0) continue;
                this.sortedPacks.add(null);
            }
        });
    }

    public void cancelClicked() {
        if (this.prevWindow == null) {
            this.close();
            return;
        }
        this.prevWindow.get().open();
    }

    public void selectClicked(Button button) {
        if (this.prevWindow == null) {
            this.close();
            return;
        }
        int index = this.packList.getListElementIndexByPane((Pane)button);
        if (button.getID().contains("1")) {
            StructurePacks.selectedPack = (StructurePackMeta)this.sortedPacks.get(index * 2);
            this.prevWindow.get().open();
        } else {
            StructurePacks.selectedPack = (StructurePackMeta)this.sortedPacks.get(index * 2 + 1);
            this.prevWindow.get().open();
        }
    }

    public void onOpened() {
        this.packMetas = Collections.emptyList();
        this.sortedPacks.clear();
        this.packMetasFuture = IOPool.submit(() -> {
            if (!StructurePacks.waitUntilFinishedLoading()) {
                return Collections.emptyList();
            }
            return new ArrayList<StructurePackMeta>(StructurePacks.getPackMetas().stream().filter(this.packPredicate).toList());
        });
        this.packList = (ScrollingList)this.findPaneOfTypeByID("packs", ScrollingList.class);
        super.onOpened();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.packMetasFuture != null && this.packMetasFuture.isDone()) {
            try {
                this.packMetas = this.packMetasFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            this.packMetasFuture = null;
            if (!this.packMetas.isEmpty()) {
                Collections.shuffle(this.packMetas, new Random(randomSeed));
            }
            TreeMap<String, List> categories = new TreeMap<String, List>();
            for (StructurePackMeta structurePackMeta : this.packMetas) {
                List catList = categories.getOrDefault(structurePackMeta.getOwner(), new ArrayList());
                catList.add(structurePackMeta);
                categories.put(structurePackMeta.getOwner(), catList);
            }
            this.sortedPacks.clear();
            for (Map.Entry entry : categories.entrySet()) {
                this.sortedPacks.add(entry.getKey());
                this.sortedPacks.add(entry.getKey());
                this.sortedPacks.addAll((Collection)entry.getValue());
                if (((List)entry.getValue()).size() % 2 == 0) continue;
                this.sortedPacks.add(null);
            }
            this.updatePacks();
        }
    }

    public void updatePacks() {
        this.packList.enable();
        this.packList.show();
        this.packList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowSwitchPack.this.sortedPacks.size() / 2;
            }

            public void updateElement(int index, Pane rowPane) {
                int metaStart = index * 2;
                Object obj1 = WindowSwitchPack.this.sortedPacks.get(metaStart);
                Object obj2 = WindowSwitchPack.this.sortedPacks.get(metaStart + 1);
                rowPane.findPaneByID("box0").hide();
                if (obj1 instanceof StructurePackMeta) {
                    StructurePackMeta meta1 = (StructurePackMeta)obj1;
                    WindowSwitchPack.fillForMeta(rowPane, meta1, "1");
                    rowPane.findPaneByID("box1").show();
                } else {
                    rowPane.findPaneByID("box1").hide();
                }
                if (obj2 instanceof StructurePackMeta) {
                    StructurePackMeta meta2 = (StructurePackMeta)obj2;
                    WindowSwitchPack.fillForMeta(rowPane, meta2, "2");
                    rowPane.findPaneByID("box2").show();
                } else {
                    rowPane.findPaneByID("box2").hide();
                }
                if (obj1 instanceof String) {
                    String str = (String)obj1;
                    rowPane.findPaneByID("box0").show();
                    ((Text)rowPane.findPaneOfTypeByID("category", Text.class)).setText(Component.m_237113_((String)StringUtils.capitalize((String)str)));
                }
            }
        });
    }

    private static void fillForMeta(Pane rowPane, StructurePackMeta packMeta, String side) {
        ((Text)rowPane.findPaneOfTypeByID("name" + side, Text.class)).setText(Component.m_237113_((String)packMeta.getName()));
        ((Text)rowPane.findPaneOfTypeByID("desc" + side, Text.class)).setText(Component.m_237113_((String)packMeta.getDesc()));
        StringBuilder author = new StringBuilder("Authors: ");
        for (int i = 0; i < packMeta.getAuthors().size(); ++i) {
            author.append(packMeta.getAuthors().get(i));
            if (i + 1 >= packMeta.getAuthors().size()) continue;
            author.append(", ");
        }
        ((Text)rowPane.findPaneOfTypeByID("authors" + side, Text.class)).setText(Component.m_237113_((String)author.toString()));
        if (!packMeta.getIconPath().isEmpty()) {
            ((Image)rowPane.findPaneOfTypeByID("icon" + side, Image.class)).setImage((ResourceLocation)OutOfJarResourceLocation.of((String)"structurize", (Path)packMeta.getPath().resolve(packMeta.getIconPath())), false);
        }
        ((Button)rowPane.findPaneOfTypeByID("select" + side, Button.class)).setTextColor(ChatFormatting.BLACK.m_126665_().intValue());
    }
}

