/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api.util;

import com.ldtteam.structurize.api.util.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockPosUtil {
    private BlockPosUtil() {
    }

    public static String format(BlockPos pos) {
        return String.format("%d %d %d", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static void writeToNBT(CompoundTag compound, String name, BlockPos pos) {
        CompoundTag coordsCompound = new CompoundTag();
        coordsCompound.m_128405_("x", pos.m_123341_());
        coordsCompound.m_128405_("y", pos.m_123342_());
        coordsCompound.m_128405_("z", pos.m_123343_());
        compound.m_128365_(name, (Tag)coordsCompound);
    }

    public static BlockPos readFromNBT(CompoundTag compound, String name) {
        CompoundTag coordsCompound = compound.m_128469_(name);
        int x = coordsCompound.m_128451_("x");
        int y = coordsCompound.m_128451_("y");
        int z = coordsCompound.m_128451_("z");
        return new BlockPos(x, y, z);
    }

    public static void writeToNBTTagList(ListTag tagList, BlockPos pos) {
        CompoundTag coordsCompound = new CompoundTag();
        coordsCompound.m_128405_("x", pos.m_123341_());
        coordsCompound.m_128405_("y", pos.m_123342_());
        coordsCompound.m_128405_("z", pos.m_123343_());
        tagList.add((Object)coordsCompound);
    }

    public static long getDistanceSquared(BlockPos block1, BlockPos block2) {
        long zDiff;
        long yDiff;
        long xDiff = (long)block1.m_123341_() - (long)block2.m_123341_();
        long result = xDiff * xDiff + (yDiff = (long)block1.m_123342_() - (long)block2.m_123342_()) * yDiff + (zDiff = (long)block1.m_123343_() - (long)block2.m_123343_()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + yDiff + " | " + zDiff);
        }
        return result;
    }

    public static Rotation getRotationFromRotations(int rotations) {
        switch (rotations) {
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static boolean isInbetween(BlockPos inside, BlockPos corner1, BlockPos corner2) {
        return BoundingBox.m_162375_((Vec3i)corner1, (Vec3i)corner2).m_71051_((Vec3i)inside);
    }

    public static BlockPos getNextPosInCircleFrom(BlockPos start, BlockPos corner1, BlockPos corner2, int ringHeight) {
        if (corner1.m_123341_() > corner2.m_123341_() || corner1.m_123343_() > corner2.m_123343_() || Math.abs(corner1.m_123341_() - corner2.m_123341_()) < 0 || Math.abs(corner1.m_123343_() - corner2.m_123343_()) < 0) {
            Log.getLogger().warn("Insufficient dimensions for:" + String.valueOf(corner1) + String.valueOf(corner2));
            return start;
        }
        int wDist = Math.abs(corner1.m_123341_() - start.m_123341_());
        int nDist = Math.abs(corner1.m_123343_() - start.m_123343_());
        int eDist = Math.abs(corner2.m_123341_() - start.m_123341_());
        int sDist = Math.abs(corner2.m_123343_() - start.m_123343_());
        Direction closestDir = Direction.NORTH;
        int closest = nDist;
        if (eDist < closest || eDist == closest && closestDir.m_122427_() == Direction.EAST) {
            closest = eDist;
            closestDir = Direction.EAST;
        }
        if (sDist < closest || sDist == closest && closestDir.m_122427_() == Direction.SOUTH) {
            closest = sDist;
            closestDir = Direction.SOUTH;
        }
        if (wDist < closest || wDist == closest && closestDir.m_122427_() == Direction.WEST) {
            closest = wDist;
            closestDir = Direction.WEST;
        }
        int outerRings = Math.min(Math.abs(corner2.m_123341_() - corner1.m_123341_()), Math.abs(corner2.m_123343_() - corner1.m_123343_())) >> 1;
        if (closestDir == Direction.WEST && nDist - wDist == 1 && wDist != outerRings) {
            int traverseRow = (start.m_123342_() - corner1.m_123342_() + 1) % ringHeight;
            if (traverseRow != 0) {
                if (start.m_123342_() < corner2.m_123342_()) {
                    return start.m_121945_(Direction.NORTH).m_7918_(0, 1, 0);
                }
                return start.m_121945_(Direction.EAST).m_7918_(0, -(traverseRow - 1), 0);
            }
            return start.m_121945_(Direction.EAST).m_7918_(0, -(ringHeight - 1), 0);
        }
        Direction advancingDir = closestDir.m_122427_();
        BlockPos next = start.m_121945_(advancingDir);
        if (nDist >= outerRings && eDist >= outerRings && sDist >= outerRings && wDist >= outerRings && (Math.abs(corner1.m_123343_() - next.m_123343_()) == outerRings || eDist == outerRings && sDist == outerRings && wDist == outerRings) && (advancingDir == Direction.WEST || advancingDir == Direction.NORTH)) {
            if (start.m_123342_() < corner2.m_123342_()) {
                if ((start.m_123342_() - corner1.m_123342_() + 1) % ringHeight != 0) {
                    return new BlockPos(corner1.m_123341_() + outerRings, Math.min(corner2.m_123342_(), start.m_123342_() + 1), corner1.m_123343_() + outerRings);
                }
                return new BlockPos(corner1.m_123341_(), Math.min(corner2.m_123342_(), start.m_123342_() + 1), corner1.m_123343_());
            }
            return start;
        }
        return next;
    }

    @Nullable
    public static BlockPos findSafeTeleportPos(@NotNull Level level, @NotNull BlockPos target, boolean falling) {
        BlockPos top = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, target).m_6630_(2);
        for (BlockPos start : BlockPos.m_121940_((BlockPos)target, (BlockPos)top)) {
            if (target.m_123342_() < level.m_141937_()) continue;
            for (BlockPos pos : BlockPos.m_121935_((BlockPos)start, (int)15, (Direction)Direction.SOUTH, (Direction)Direction.EAST)) {
                if (!level.m_46859_(pos) || !level.m_46859_(pos.m_7494_()) || falling && level.m_46859_(pos.m_7495_()) && level.m_46859_(pos.m_6625_(2)) && level.m_46859_(pos.m_6625_(3))) continue;
                return pos;
            }
        }
        return null;
    }
}

