/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.gravestone.corelib.client.PlayerSkins;
import de.maxhenkel.gravestone.entity.GhostPlayerEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;

public class PlayerGhostRenderer
extends LivingEntityRenderer<GhostPlayerEntity, PlayerModel<GhostPlayerEntity>> {
    private PlayerModel<GhostPlayerEntity> playerModel;
    private PlayerModel<GhostPlayerEntity> playerModelSmallArms;

    public PlayerGhostRenderer(EntityRendererProvider.Context renderer) {
        super(renderer, null, 0.5f);
        this.playerModel = new PlayerModel(renderer.m_174023_(ModelLayers.f_171162_), false);
        this.playerModelSmallArms = new PlayerModel(renderer.m_174023_(ModelLayers.f_171166_), true);
        this.f_115290_ = this.playerModel;
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(renderer.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(renderer.m_174023_(ModelLayers.f_171165_)), Minecraft.m_91087_().m_91304_()));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, renderer.m_174027_(), 1.0f, 1.0f, 1.0f, Minecraft.m_91087_().f_91063_.f_109055_));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, renderer.m_174027_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, Minecraft.m_91087_().f_91063_.f_109055_));
    }

    protected void scale(GhostPlayerEntity ghost, PoseStack matrixStack, float partialTickTime) {
        float scale = 0.9375f;
        matrixStack.m_85841_(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(GhostPlayerEntity entity) {
        return PlayerSkins.getSkin(entity.getPlayerUUID(), entity.m_7755_().getString());
    }

    public void render(GhostPlayerEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.m_85836_();
        this.f_115290_ = PlayerSkins.isSlim(entity.getPlayerUUID()) ? this.playerModelSmallArms : this.playerModel;
        this.setModelVisibilities(entity);
        super.m_7392_((LivingEntity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        matrixStack.m_85849_();
    }

    private void setModelVisibilities(GhostPlayerEntity playerEntity) {
        ((PlayerModel)this.f_115290_).f_102809_.f_104207_ = playerEntity.isWearing(PlayerModelPart.HAT);
        ((PlayerModel)this.f_115290_).f_103378_.f_104207_ = playerEntity.isWearing(PlayerModelPart.JACKET);
        ((PlayerModel)this.f_115290_).f_103376_.f_104207_ = playerEntity.isWearing(PlayerModelPart.LEFT_PANTS_LEG);
        ((PlayerModel)this.f_115290_).f_103377_.f_104207_ = playerEntity.isWearing(PlayerModelPart.RIGHT_PANTS_LEG);
        ((PlayerModel)this.f_115290_).f_103374_.f_104207_ = playerEntity.isWearing(PlayerModelPart.LEFT_SLEEVE);
        ((PlayerModel)this.f_115290_).f_103375_.f_104207_ = playerEntity.isWearing(PlayerModelPart.RIGHT_SLEEVE);
    }
}

