/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.network.packet;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedscripting.inventory.container.ContainerTerminalScripting;

public class TerminalScriptingModifiedScriptPacket
extends PacketCodec {
    @CodecField
    private int disk;
    @CodecField
    private String path;
    @CodecField
    private List<String> script;

    public TerminalScriptingModifiedScriptPacket() {
    }

    public TerminalScriptingModifiedScriptPacket(int disk, Path path, String script) {
        this.disk = disk;
        this.path = path.toString();
        this.script = Arrays.stream(script.split("\n")).toList();
    }

    public String getScript() {
        return String.join((CharSequence)"\n", this.script);
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ContainerTerminalScripting) {
            ContainerTerminalScripting container = (ContainerTerminalScripting)abstractContainerMenu;
            container.setLastScript(this.disk, Path.of(this.path, new String[0]), this.getScript());
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ContainerTerminalScripting) {
            ContainerTerminalScripting container = (ContainerTerminalScripting)abstractContainerMenu;
            container.setServerScript(this.disk, Path.of(this.path, new String[0]), this.getScript());
        }
    }
}

