/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.evaluate.translation.translator;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.api.evaluate.translation.IValueTranslator;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.evaluate.translation.translator.ValueObjectProxyObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;

public class ValueTranslatorObjectAdapter<V extends IValue>
implements IValueTranslator<V> {
    private final String key;
    private final Set<String> keys;
    private final ValueObjectTypeBase<V> valueType;
    @Nullable
    private Map<String, IOperator> methodsCache;

    public ValueTranslatorObjectAdapter(String key, ValueObjectTypeBase<V> valueType) {
        this.key = key;
        this.keys = Sets.newHashSet((Object[])new String[]{this.key});
        this.valueType = valueType;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public IValueType<?> getValueType() {
        return this.valueType;
    }

    @Override
    public boolean canHandleGraalValue(Value value) {
        if (value.isProxyObject()) {
            try {
                ValueObjectProxyObject proxyObject = (ValueObjectProxyObject)value.asProxyObject();
                return proxyObject.getValue() != null && proxyObject.getValue().getType() == this.valueType;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return value.getMemberKeys().equals(this.keys);
    }

    @Override
    public boolean canTranslateNbt() {
        return true;
    }

    protected Map<String, IOperator> getMethods() {
        HashMap methods = this.methodsCache;
        if (methods == null) {
            HashSet valueTypes = Sets.newHashSet();
            for (IValueType valueType : ValueTypes.REGISTRY.getValueTypes()) {
                if (!valueType.correspondsTo(this.valueType)) continue;
                valueTypes.add(valueType);
            }
            methods = Maps.newHashMap();
            for (IValueType valueType : valueTypes) {
                Map scopedOperators = (Map)Operators.REGISTRY.getScopedInteractOperators().get(valueType);
                if (scopedOperators == null) continue;
                methods.putAll(scopedOperators);
            }
            this.methodsCache = methods;
        }
        return methods;
    }

    @Override
    public Value translateToGraal(Context context, V value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        return context.asValue(new ValueObjectProxyObject<V>(context, exceptionFactory, this.key, this.getMethods(), this.valueType, value));
    }

    @Override
    public V translateFromGraal(Context context, Value value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        if (value.isProxyObject()) {
            try {
                ValueObjectProxyObject proxyObject = (ValueObjectProxyObject)value.asProxyObject();
                return (V)proxyObject.getValue();
            }
            catch (ClassCastException proxyObject) {
                // empty catch block
            }
        }
        Value idBlock = value.getMember(this.key);
        ValueTypeNbt.ValueNbt valueNbt = (ValueTypeNbt.ValueNbt)ValueTranslators.REGISTRY.translateFromGraal(context, idBlock, exceptionFactory);
        return (V)this.valueType.deserialize(ValueDeseralizationContext.ofAllEnabled(), (Tag)valueNbt.getRawValue().orElseThrow());
    }

    @Override
    public Tag translateToNbt(Context context, V value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        throw exceptionFactory.createError(Component.m_237110_((String)"valuetype.integratedscripting.error.translation.unsupported_translateToNbt", (Object[])new Object[]{Component.m_237115_((String)value.getType().getTranslationKey()), value.getType().toCompactString(value)}));
    }
}

