/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.evaluate.translation.translator;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.evaluate.operator.CurriedOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.proxy.ProxyObject;

public class ValueObjectProxyObject<V extends IValue>
implements ProxyObject {
    private final Context context;
    private final IEvaluationExceptionFactory exceptionFactory;
    private final ValueObjectTypeBase<V> valueType;
    private final V value;
    private final Map<String, IOperator> methods;
    private final String memberNbtKey;
    @Nullable
    private Value memberNbtValue;

    public ValueObjectProxyObject(Context context, IEvaluationExceptionFactory exceptionFactory, String memberNbtKey, Map<String, IOperator> methods, ValueObjectTypeBase<V> valueType, V value) {
        this.context = context;
        this.exceptionFactory = exceptionFactory;
        this.valueType = valueType;
        this.methods = methods;
        this.value = value;
        this.memberNbtKey = memberNbtKey;
    }

    public ValueObjectTypeBase<V> getValueType() {
        return this.valueType;
    }

    @Nullable
    public IValue getValue() {
        return this.value;
    }

    @Override
    public Object getMember(String key) {
        IOperator operator = this.methods.get(key);
        if (operator != null) {
            CurriedOperator curriedOperator = new CurriedOperator(operator, new IVariable[]{new Variable(this.value)});
            return ValueTranslators.REGISTRY.translateToGraal(this.context, ValueTypeOperator.ValueOperator.of((IOperator)curriedOperator), this.exceptionFactory);
        }
        if (key.equals(this.memberNbtKey)) {
            if (this.memberNbtValue == null) {
                Tag tag = this.valueType.serialize(this.value);
                this.memberNbtValue = ValueTranslators.TRANSLATOR_NBT.translateTag(this.context, tag, this.exceptionFactory);
            }
            return this.memberNbtValue;
        }
        return null;
    }

    @Override
    public Object getMemberKeys() {
        return new String[]{this.memberNbtKey};
    }

    @Override
    public boolean hasMember(String key) {
        return key.equals(this.memberNbtKey) || this.methods != null && this.methods.containsKey(key);
    }

    @Override
    public void putMember(String key, Value value) {
        throw this.exceptionFactory.createError(Component.m_237110_((String)"valuetype.integratedscripting.error.translation.proxyobject_putMember", (Object[])new Object[]{key, this.valueType.getTypeName()}));
    }
}

