/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.client.gui.component.input;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integratedscripting.client.gui.component.input.TextFieldHelperExtended;

@OnlyIn(value=Dist.CLIENT)
public class WidgetTextArea
extends EditBox
implements GuiEventListener {
    public static final int ROW_HEIGHT = 9;
    private final TextFieldHelperExtended textFieldHelper;
    private final Font font;
    private final boolean showLineNumbers;
    private int frameTick;
    private String value = "";
    private String selected = "";
    @Nullable
    private IInputListener listener;
    @Nullable
    private IInputListener listenerSelection;
    @Nullable
    private IInputListener listenerCursor;
    @Nullable
    private IMarkupProvider markupProvider;
    private DisplayCache emptyDisplayCache;
    @Nullable
    private DisplayCache displayCache = this.emptyDisplayCache = this.createEmptyDisplayCache();
    private long lastClickTime;
    private int lastIndex = -1;
    @Nullable
    private WidgetScrollBar scrollBar;
    private int firstRow;

    public WidgetTextArea(Font font, int x2, int y2, int width, int height, Component narrationMessage, boolean scrollBar, boolean showLineNumbers) {
        super(font, x2, y2, width, height, narrationMessage);
        this.font = font;
        this.showLineNumbers = showLineNumbers;
        this.textFieldHelper = new TextFieldHelperExtended(this::m_94155_, this::setValuePassive, this::getClipboard, this::setClipboard, s2 -> true, this::setSelected, this::onCursorPosChanged);
        if (scrollBar) {
            this.scrollBar = new WidgetScrollBar(x2 + width - 14, y2, height, (Component)Component.m_237115_((String)"gui.cyclopscore.scrollbar"), firstRow -> this.setFirstRow(firstRow, false), height / 9){

                public int getTotalRows() {
                    return WidgetTextArea.this.getDisplayCache().linesTotal;
                }

                public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    if (this.needsScrollBars()) {
                        super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
                    }
                }
            };
        }
    }

    private DisplayCache createEmptyDisplayCache() {
        Pos2i pos = this.convertLocalToScreen(new Pos2i(0, 0));
        return new DisplayCache("", pos, true, new int[]{0}, new LineInfo[]{new LineInfo(Collections.emptyList(), pos.x, pos.y, 0, false)}, new LineInfo[]{new LineInfo(Collections.emptyList(), pos.x, pos.y, 0, false)}, new Rect2i[0], 0, 0);
    }

    public void setFirstRow(int firstRow, boolean propagateToScrollbar) {
        this.firstRow = firstRow;
        if (this.scrollBar != null) {
            int linesTotal = this.getDisplayCache().linesTotal;
            if (this.firstRow > linesTotal - this.scrollBar.getVisibleRows()) {
                this.firstRow = linesTotal - this.scrollBar.getVisibleRows();
            }
            if (this.firstRow < 0) {
                this.firstRow = 0;
            }
            if (propagateToScrollbar) {
                this.scrollBar.setFirstRow(this.firstRow, false);
            }
        }
        this.clearDisplayCache();
    }

    public void setListener(@Nullable IInputListener listener) {
        this.listener = listener;
    }

    public void setListenerSelection(@Nullable IInputListener listenerSelection) {
        this.listenerSelection = listenerSelection;
    }

    public void setListenerCursor(@Nullable IInputListener listenerCursor) {
        this.listenerCursor = listenerCursor;
    }

    public void setMarkupProvider(@Nullable IMarkupProvider markupProvider) {
        this.markupProvider = markupProvider;
    }

    public void m_94144_(String value) {
        this.setValuePassive(value);
        this.textFieldHelper.m_169097_();
        this.textFieldHelper.m_169100_(this.textFieldHelper.m_95194_());
        if (this.scrollBar != null) {
            this.firstRow = 0;
            this.scrollBar.scrollTo(0.0f);
        }
    }

    public void setValuePassive(String value) {
        this.value = value;
        this.clearDisplayCache();
        if (this.listener != null) {
            this.listener.onChanged();
        }
    }

    public String m_94155_() {
        return this.value;
    }

    public void setSelected(String value) {
        this.selected = value;
        if (this.listenerSelection != null) {
            this.listenerSelection.onChanged();
        }
    }

    public String getSelected() {
        return this.selected;
    }

    public int getCursorPos() {
        return this.textFieldHelper.m_95194_();
    }

    public void setCursorPos(int pos) {
        this.textFieldHelper.m_95179_(pos, true);
    }

    private void onCursorPosChanged(int cursorPos) {
        if (this.listenerCursor != null) {
            this.listenerCursor.onChanged();
        }
    }

    public int getSelectionPos() {
        return this.textFieldHelper.m_95197_();
    }

    public void setSelectionPos(int pos) {
        this.textFieldHelper.m_169100_(pos);
    }

    public void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"narration.edit_box", (Object[])new Object[]{this.m_94155_()}));
    }

    private void setClipboard(String value) {
        TextFieldHelper.m_95155_((Minecraft)Minecraft.m_91087_(), (String)value);
    }

    private String getClipboard() {
        return TextFieldHelper.m_95169_((Minecraft)Minecraft.m_91087_());
    }

    public void m_94120_() {
        ++this.frameTick;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1 && mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_)) {
            this.m_93692_(true);
            this.textFieldHelper.m_95188_();
            return true;
        }
        if (mouseButton == 0 && mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_)) {
            this.m_93692_(true);
            long i2 = Util.m_137550_();
            DisplayCache displayCache = this.getDisplayCache();
            int j2 = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            if (j2 >= 0) {
                if (j2 == this.lastIndex && i2 - this.lastClickTime < 250L) {
                    if (!this.textFieldHelper.m_95198_()) {
                        this.selectWord(j2);
                    } else {
                        this.textFieldHelper.m_95188_();
                    }
                } else {
                    this.textFieldHelper.m_95179_(j2, Screen.m_96638_());
                }
                this.clearDisplayCache();
            }
            this.lastIndex = j2;
            this.lastClickTime = i2;
            this.m_93692_(true);
        } else {
            this.m_93692_(false);
        }
        return this.m_93696_();
    }

    private void selectWord(int p_98142_) {
        String value = this.m_94155_();
        this.textFieldHelper.m_95147_(StringSplitter.m_92355_((String)value, (int)-1, (int)p_98142_, (boolean)false), StringSplitter.m_92355_((String)value, (int)1, (int)p_98142_, (boolean)false));
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return this.scrollBar != null && mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_) && this.scrollBar.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double offsetX, double offsetY) {
        if (this.scrollBar != null && mouseX >= (double)(this.m_252754_() + this.f_93618_ - 12) && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_)) {
            return this.scrollBar.m_7979_(mouseX, mouseY, mouseButton, offsetX, offsetY);
        }
        if (mouseButton == 0 && mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_)) {
            DisplayCache bookeditscreen$displaycache = this.getDisplayCache();
            int i2 = bookeditscreen$displaycache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            this.textFieldHelper.m_95179_(i2, true);
            this.clearDisplayCache();
            this.m_93692_(true);
        }
        return true;
    }

    public boolean m_7933_(int typedChar, int keyCode, int modifiers) {
        boolean flag = this.textFieldKeyPressed(typedChar, keyCode, modifiers);
        if (flag) {
            this.clearDisplayCache();
            this.m_93692_(true);
            return true;
        }
        this.m_93692_(false);
        return false;
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (super.m_5534_(typedChar, keyCode)) {
            this.m_93692_(true);
            return true;
        }
        if (SharedConstants.m_136188_((char)typedChar)) {
            this.textFieldHelper.m_95158_(Character.toString(typedChar));
            this.clearDisplayCache();
            this.m_93692_(true);
            return true;
        }
        this.m_93692_(false);
        return false;
    }

    private boolean textFieldKeyPressed(int p_98153_, int p_98154_, int p_98155_) {
        if (Screen.m_96634_((int)p_98153_)) {
            this.textFieldHelper.m_95188_();
            return true;
        }
        if (Screen.m_96632_((int)p_98153_)) {
            this.textFieldHelper.m_95178_();
            return true;
        }
        if (Screen.m_96630_((int)p_98153_)) {
            this.textFieldHelper.m_95165_();
            return true;
        }
        if (Screen.m_96628_((int)p_98153_)) {
            this.textFieldHelper.m_95142_();
            return true;
        }
        TextFieldHelper.CursorStep cursorStep = Screen.m_96637_() ? TextFieldHelper.CursorStep.WORD : TextFieldHelper.CursorStep.CHARACTER;
        switch (p_98153_) {
            case 257: 
            case 335: {
                this.textFieldHelper.m_95158_("\n");
                return true;
            }
            case 259: {
                this.textFieldHelper.m_232572_(-1, cursorStep);
                return true;
            }
            case 261: {
                this.textFieldHelper.m_232572_(1, cursorStep);
                return true;
            }
            case 262: {
                this.textFieldHelper.m_232575_(1, Screen.m_96638_(), cursorStep);
                return true;
            }
            case 263: {
                this.textFieldHelper.m_232575_(-1, Screen.m_96638_(), cursorStep);
                return true;
            }
            case 264: {
                this.keyDown();
                return true;
            }
            case 265: {
                this.keyUp();
                return true;
            }
            case 266: {
                return true;
            }
            case 267: {
                return true;
            }
            case 268: {
                this.keyHome();
                return true;
            }
            case 269: {
                this.keyEnd();
                return true;
            }
        }
        return false;
    }

    private void keyUp() {
        this.changeLine(-1);
    }

    private void keyDown() {
        this.changeLine(1);
    }

    private void changeLine(int p_98098_) {
        int cursorPos = this.textFieldHelper.m_95194_();
        DisplayCache displayCache = this.getDisplayCache();
        int j2 = displayCache.changeLine(cursorPos, p_98098_);
        this.textFieldHelper.m_95179_(j2, Screen.m_96638_());
        if (this.scrollBar != null) {
            int cursorLine = WidgetTextArea.findLineFromPos(Arrays.stream(displayCache.lineStarts).toArray(), cursorPos);
            if (cursorLine < this.firstRow + 2) {
                this.setFirstRow(cursorLine - 2, true);
            } else if (cursorLine > this.firstRow + this.scrollBar.getVisibleRows() - 3) {
                this.setFirstRow(cursorLine - (this.scrollBar.getVisibleRows() - 3), true);
            }
        }
    }

    private void keyHome() {
        if (Screen.m_96637_()) {
            this.textFieldHelper.m_95176_(Screen.m_96638_());
        } else {
            int i2 = this.textFieldHelper.m_95194_();
            int j2 = this.getDisplayCache().findLineStart(i2);
            this.textFieldHelper.m_95179_(j2, Screen.m_96638_());
        }
    }

    private void keyEnd() {
        if (Screen.m_96637_()) {
            this.textFieldHelper.m_95186_(Screen.m_96638_());
        } else {
            DisplayCache displayCache = this.getDisplayCache();
            int i2 = this.textFieldHelper.m_95194_();
            int j2 = displayCache.findLineEnd(i2);
            this.textFieldHelper.m_95179_(j2, Screen.m_96638_());
        }
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        DisplayCache displayCache = this.getDisplayCache();
        List<LineInfo> lines = Arrays.asList(displayCache.lines);
        int offsetY = 0;
        int lastLineNumber = -1;
        for (LineInfo line : lines) {
            guiGraphics.m_280614_(this.font, line.asComponent, line.x, line.y - offsetY, -16777216, false);
            if (this.showLineNumbers && lastLineNumber != line.lineNumber) {
                RenderHelpers.drawScaledString((GuiGraphics)guiGraphics, (Font)this.font, (String)String.valueOf(line.lineNumber), (int)this.m_252754_(), (int)(line.y - offsetY + 2), (float)0.5f, (int)(line.hasCursor ? 0 : Helpers.RGBToInt((int)120, (int)120, (int)120)), (boolean)false, (Font.DisplayMode)Font.DisplayMode.NORMAL);
            }
            lastLineNumber = line.lineNumber;
        }
        this.renderHighlight(displayCache.selection);
        if (displayCache.cursor != null) {
            this.renderCursor(guiGraphics, displayCache.cursor, displayCache.cursorAtEnd);
        }
        if (this.scrollBar != null) {
            this.scrollBar.m_88315_(guiGraphics, this.m_252754_(), this.m_252907_(), partialTicks);
        }
    }

    private void renderCursor(GuiGraphics guiGraphics, Pos2i pos, boolean cursorAtEnd) {
        if (this.m_93696_() && this.frameTick / 6 % 2 == 0) {
            pos = this.convertLocalToScreen(pos);
            if (!cursorAtEnd) {
                guiGraphics.m_280509_(pos.x, pos.y - 1, pos.x + 1, pos.y + 9, -16777216);
            } else {
                guiGraphics.m_280488_(this.font, "_", pos.x, pos.y, 0);
            }
        }
    }

    private void renderHighlight(Rect2i[] p_98139_) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)(this.m_93696_() ? 255.0f : 100.0f), (float)255.0f);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (Rect2i rect2i : p_98139_) {
            int i2 = rect2i.m_110085_();
            int j2 = rect2i.m_110086_();
            int k2 = i2 + rect2i.m_110090_();
            int l2 = j2 + rect2i.m_110091_();
            bufferbuilder.m_5483_((double)i2, (double)l2, 0.0).m_5752_();
            bufferbuilder.m_5483_((double)k2, (double)l2, 0.0).m_5752_();
            bufferbuilder.m_5483_((double)k2, (double)j2, 0.0).m_5752_();
            bufferbuilder.m_5483_((double)i2, (double)j2, 0.0).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.disableColorLogicOp();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private int getLinesXOffset() {
        return this.showLineNumbers ? 14 : 0;
    }

    private Pos2i convertScreenToLocal(Pos2i posScreen) {
        return new Pos2i(posScreen.x - this.m_252754_() - this.getLinesXOffset(), posScreen.y - this.m_252907_());
    }

    private Pos2i convertLocalToScreen(Pos2i posLocal) {
        return new Pos2i(this.m_252754_() + posLocal.x + this.getLinesXOffset(), this.m_252907_() + posLocal.y);
    }

    private DisplayCache getDisplayCache() {
        if (this.displayCache == null) {
            this.displayCache = this.rebuildDisplayCache();
        }
        return this.displayCache;
    }

    private void clearDisplayCache() {
        this.displayCache = null;
    }

    private DisplayCache rebuildDisplayCache() {
        Pos2i cursor;
        boolean flag;
        String s2 = this.m_94155_();
        if (s2.isEmpty()) {
            return this.emptyDisplayCache;
        }
        int cursorPos = this.textFieldHelper.m_95194_();
        int selectionPos = this.textFieldHelper.m_95197_();
        IntArrayList linePositionsOld = new IntArrayList();
        ArrayList linesAll = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        StringSplitter stringsplitter = this.font.m_92865_();
        MutableInt lineNumber = new MutableInt();
        stringsplitter.m_92364_(s2, this.m_5711_() - this.getLinesXOffset(), Style.f_131099_, true, (arg_0, arg_1, arg_2) -> this.lambda$rebuildDisplayCache$2(mutableint, s2, mutableboolean, (IntList)linePositionsOld, linesAll, lineNumber, cursorPos, arg_0, arg_1, arg_2));
        int linesTotal = linesAll.size();
        List lines = linesAll;
        IntArrayList lineStarts = linePositionsOld;
        if (this.scrollBar != null) {
            lines = lines.subList(this.firstRow, Math.min(this.firstRow + this.scrollBar.getVisibleRows(), lines.size()));
        }
        int[] lineStartsArr = lineStarts.toIntArray();
        boolean bl = flag = cursorPos == s2.length();
        if (flag && mutableboolean.isTrue()) {
            cursor = new Pos2i(0, lines.size() * 9);
        } else {
            int cursorLine = WidgetTextArea.findLineFromPos(lineStartsArr, cursorPos);
            int cursorX = this.font.m_92895_(s2.substring(lineStartsArr[cursorLine], cursorPos));
            cursor = new Pos2i(cursorX, (cursorLine - this.firstRow) * 9);
        }
        if (cursor.y < 0 || cursor.y > this.m_93694_()) {
            cursor = null;
        }
        ArrayList selection = Lists.newArrayList();
        if (cursorPos != selectionPos) {
            int lineEnd;
            int l2 = Math.min(cursorPos, selectionPos);
            int i1 = Math.max(cursorPos, selectionPos);
            int lineStart = WidgetTextArea.findLineFromPos(lineStartsArr, l2);
            if (lineStart == (lineEnd = WidgetTextArea.findLineFromPos(lineStartsArr, i1))) {
                int l1 = lineStart * 9;
                int i2 = lineStartsArr[lineStart];
                selection.add(this.createPartialLineSelection(s2, stringsplitter, l2, i1, l1, i2));
            } else {
                int i3 = lineStart + 1 > lineStartsArr.length ? s2.length() : lineStartsArr[lineStart + 1];
                selection.add(this.createPartialLineSelection(s2, stringsplitter, l2, i3, lineStart * 9, lineStartsArr[lineStart]));
                for (int j3 = lineStart + 1; j3 < lineEnd; ++j3) {
                    int j2 = j3 * 9;
                    String s1 = s2.substring(lineStartsArr[j3], lineStartsArr[j3 + 1]);
                    int k2 = (int)stringsplitter.m_92353_(s1);
                    selection.add(this.createSelection(new Pos2i(0, j2), new Pos2i(k2, j2 + 9)));
                }
                selection.add(this.createPartialLineSelection(s2, stringsplitter, lineStartsArr[lineEnd], i1, lineEnd * 9, lineStartsArr[lineEnd]));
            }
        }
        ArrayList selectionNew = Lists.newArrayList();
        for (Rect2i rect2i : selection) {
            Rect2i rect2iNew = new Rect2i(rect2i.m_110085_(), rect2i.m_110086_() - this.firstRow * 9, rect2i.m_110090_(), rect2i.m_110091_());
            if (rect2iNew.m_110086_() - this.m_252907_() < 0 || rect2iNew.m_110086_() - this.m_252907_() >= this.m_93694_()) continue;
            selectionNew.add(rect2iNew);
        }
        return new DisplayCache(s2, cursor, flag, lineStartsArr, lines.toArray(new LineInfo[0]), linesAll.toArray(new LineInfo[0]), selectionNew.toArray(new Rect2i[0]), linesTotal, this.firstRow);
    }

    private List<Pair<Style, String>> markupLine(Style style, String line) {
        if (this.markupProvider != null) {
            return this.markupProvider.markupLine(style, line);
        }
        return Stream.of(Pair.of((Object)style, (Object)line)).collect(Collectors.toList());
    }

    static int findLineFromPos(int[] p_98150_, int p_98151_) {
        int i2 = Arrays.binarySearch(p_98150_, p_98151_);
        return i2 < 0 ? -(i2 + 2) : i2;
    }

    private Rect2i createPartialLineSelection(String p_98120_, StringSplitter p_98121_, int p_98122_, int p_98123_, int p_98124_, int p_98125_) {
        String s2 = p_98120_.substring(p_98125_, p_98122_);
        String s1 = p_98120_.substring(p_98125_, p_98123_);
        Pos2i bookeditscreen$pos2i = new Pos2i((int)p_98121_.m_92353_(s2), p_98124_);
        Pos2i bookeditscreen$pos2i1 = new Pos2i((int)p_98121_.m_92353_(s1), p_98124_ + 9);
        return this.createSelection(bookeditscreen$pos2i, bookeditscreen$pos2i1);
    }

    private Rect2i createSelection(Pos2i p_98117_, Pos2i p_98118_) {
        Pos2i bookeditscreen$pos2i = this.convertLocalToScreen(p_98117_);
        Pos2i bookeditscreen$pos2i1 = this.convertLocalToScreen(p_98118_);
        int i2 = Math.min(bookeditscreen$pos2i.x, bookeditscreen$pos2i1.x);
        int j2 = Math.max(bookeditscreen$pos2i.x, bookeditscreen$pos2i1.x);
        int k2 = Math.min(bookeditscreen$pos2i.y, bookeditscreen$pos2i1.y);
        int l2 = Math.max(bookeditscreen$pos2i.y, bookeditscreen$pos2i1.y);
        return new Rect2i(i2, k2, j2 - i2, l2 - k2);
    }

    private /* synthetic */ void lambda$rebuildDisplayCache$2(MutableInt mutableint, String s2, MutableBoolean mutableboolean, IntList linePositionsOld, List linesAll, MutableInt lineNumber, int cursorPos, Style style, int startPos, int endPos) {
        int k3 = mutableint.getAndIncrement();
        String stringPart = s2.substring(startPos, endPos);
        boolean hasNewLine = stringPart.endsWith("\n");
        mutableboolean.setValue(hasNewLine);
        String s3 = StringUtils.stripEnd((String)stringPart, (String)" \n");
        int l3 = (k3 - this.firstRow) * 9;
        Pos2i bookeditscreen$pos2i1 = this.convertLocalToScreen(new Pos2i(0, l3));
        linePositionsOld.add(startPos);
        linesAll.add(new LineInfo(this.markupLine(style, s3), bookeditscreen$pos2i1.x, bookeditscreen$pos2i1.y, lineNumber.getValue(), cursorPos >= startPos && cursorPos < (hasNewLine ? endPos : s2.indexOf("\n", endPos))));
        if (hasNewLine) {
            lineNumber.increment();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DisplayCache {
        private final String fullText;
        @Nullable
        final Pos2i cursor;
        final boolean cursorAtEnd;
        private final int[] lineStarts;
        final LineInfo[] lines;
        final LineInfo[] linesAll;
        final Rect2i[] selection;
        final int linesTotal;
        final int firstRow;

        public DisplayCache(String p_98201_, Pos2i cursor, boolean p_98203_, int[] p_98204_, LineInfo[] lines, LineInfo[] linesAll, Rect2i[] selection, int linesTotal, int firstRow) {
            this.fullText = p_98201_;
            this.cursor = cursor;
            this.cursorAtEnd = p_98203_;
            this.lineStarts = p_98204_;
            this.lines = lines;
            this.linesAll = linesAll;
            this.selection = selection;
            this.linesTotal = linesTotal;
            this.firstRow = firstRow;
        }

        public int getIndexAtPosition(Font p_98214_, Pos2i p_98215_) {
            int i2 = p_98215_.y / 9 + this.firstRow;
            if (i2 < 0) {
                return 0;
            }
            if (i2 >= this.linesAll.length) {
                return this.fullText.length();
            }
            LineInfo bookeditscreen$lineinfo = this.linesAll[i2];
            return this.lineStarts[i2] + p_98214_.m_92865_().m_92360_(bookeditscreen$lineinfo.contents, p_98215_.x, Style.f_131099_);
        }

        public int changeLine(int p_98211_, int p_98212_) {
            int k2;
            int i2 = WidgetTextArea.findLineFromPos(this.lineStarts, p_98211_);
            int j2 = i2 + p_98212_;
            if (0 <= j2 && j2 < this.lineStarts.length) {
                int l2 = p_98211_ - this.lineStarts[i2];
                int i1 = this.linesAll[j2].contents.length();
                k2 = this.lineStarts[j2] + Math.min(l2, i1);
            } else {
                k2 = p_98211_;
            }
            return k2;
        }

        public int findLineStart(int p_98209_) {
            int i2 = WidgetTextArea.findLineFromPos(this.lineStarts, p_98209_);
            return this.lineStarts[i2];
        }

        public int findLineEnd(int p_98219_) {
            int i2 = WidgetTextArea.findLineFromPos(this.lineStarts, p_98219_);
            return this.lineStarts[i2] + this.linesAll[i2].contents.length();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Pos2i {
        public final int x;
        public final int y;

        Pos2i(int p_98249_, int p_98250_) {
            this.x = p_98249_;
            this.y = p_98250_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class LineInfo {
        final List<Pair<Style, String>> contentsStyled;
        final String contents;
        final Component asComponent;
        final int x;
        final int y;
        final int lineNumber;
        final boolean hasCursor;

        public LineInfo(List<Pair<Style, String>> contentsStyled, int x2, int y2, int lineNumber, boolean hasCursor) {
            this.contentsStyled = contentsStyled;
            this.contents = contentsStyled.stream().map(Pair::getRight).collect(Collectors.joining());
            this.x = x2;
            this.y = y2;
            this.lineNumber = lineNumber;
            this.hasCursor = hasCursor;
            MutableComponent component = Component.m_237113_((String)"");
            for (Pair<Style, String> value : contentsStyled) {
                component = component.m_7220_((Component)Component.m_237113_((String)((String)value.getRight())).m_6270_((Style)value.getLeft()));
            }
            this.asComponent = component;
        }
    }

    public static interface IMarkupProvider {
        public List<Pair<Style, String>> markupLine(Style var1, String var2);
    }
}

