/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.blockentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectableInventory;
import org.cyclops.integratedscripting.RegistryEntries;
import org.cyclops.integratedscripting.core.network.ScriptingDriveNetworkElement;
import org.cyclops.integratedscripting.core.network.ScriptingNetworkHelpers;
import org.cyclops.integratedscripting.inventory.container.ContainerScriptingDrive;
import org.cyclops.integratedscripting.item.ItemScriptingDisk;

public class BlockEntityScriptingDrive
extends BlockEntityCableConnectableInventory
implements IDirtyMarkListener,
MenuProvider {
    public static final int ROWS = 1;
    public static final int COLS = 1;
    public static final int INVENTORY_SIZE = 1;
    private int exposedDiskId = -1;

    public BlockEntityScriptingDrive(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_SCRIPTING_DRIVE, blockPos, blockState, 1, 1);
        this.getInventory().addDirtyMarkListener((IDirtyMarkListener)this);
        this.addCapabilityInternal(ForgeCapabilities.ITEM_HANDLER, LazyOptional.of(() -> this.getInventory().getItemHandler()));
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new ScriptingDriveNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos), () -> BlockEntityScriptingDrive.this.getExposedDiskId());
            }
        }));
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        this.exposedDiskId = tag.m_128451_("exposedDiskId");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("exposedDiskId", this.exposedDiskId);
    }

    public int getExposedDiskId() {
        return this.exposedDiskId;
    }

    public void setExposedDiskId(int exposedDiskId) {
        int oldExposedDiskId = this.exposedDiskId;
        this.exposedDiskId = exposedDiskId;
        if (oldExposedDiskId != exposedDiskId) {
            this.onDirty();
            ScriptingNetworkHelpers.getScriptingNetwork(this.getNetwork()).ifPresent(scriptingNetwork -> {
                if (exposedDiskId == -1) {
                    scriptingNetwork.removeDisk(oldExposedDiskId);
                } else {
                    scriptingNetwork.addDisk(exposedDiskId);
                }
            });
        }
    }

    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean m_7013_(int slot, ItemStack itemStack) {
                return super.m_7013_(slot, itemStack) && (itemStack.m_41619_() || itemStack.m_41720_() instanceof ItemScriptingDisk);
            }

            protected void onInventoryChanged() {
                super.onInventoryChanged();
                ItemStack itemStack = this.m_8020_(0);
                int id = -1;
                Item item = itemStack.m_41720_();
                if (item instanceof ItemScriptingDisk) {
                    ItemScriptingDisk itemScriptingDisk = (ItemScriptingDisk)item;
                    id = itemScriptingDisk.getOrCreateDiskId(itemStack);
                }
                BlockEntityScriptingDrive.this.setExposedDiskId(id);
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerScriptingDrive(id, playerInventory, (Container)this.getInventory());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.integratedscripting.scripting_drive");
    }
}

