/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonArray;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.EmptyArrays;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.Objects;
import java.util.PrimitiveIterator;

public class GroupBoundaries
implements JsonConvertible {
    private final TBitSet updateIndices;
    private final TBitSet clearIndices;
    private final int lastGroup;
    private final int cachedHash;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] updateArrayByte;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] clearArrayByte;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private short[] updateArray;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private short[] clearArray;

    GroupBoundaries(TBitSet updateIndices, TBitSet clearIndices, int lastGroup) {
        this.updateIndices = updateIndices;
        this.clearIndices = clearIndices;
        this.lastGroup = lastGroup;
        this.cachedHash = (Objects.hashCode(updateIndices) * 31 + Objects.hashCode(clearIndices)) * 31 + lastGroup;
    }

    public static GroupBoundaries[] createCachedGroupBoundaries() {
        GroupBoundaries[] instances = new GroupBoundaries[TBitSet.getNumberOfStaticInstances()];
        for (int i2 = 0; i2 < instances.length; ++i2) {
            instances[i2] = new GroupBoundaries(TBitSet.getStaticInstance(i2), TBitSet.getEmptyInstance(), -1);
        }
        return instances;
    }

    public static GroupBoundaries getStaticInstance(RegexLanguage language, TBitSet updateIndices, TBitSet clearIndices) {
        int key;
        if (clearIndices.isEmpty() && (key = updateIndices.getStaticCacheKey()) >= 0) {
            return language.getCachedGroupBoundaries()[key];
        }
        return null;
    }

    public static GroupBoundaries getEmptyInstance(RegexLanguage language) {
        return language.getCachedGroupBoundaries()[0];
    }

    public boolean isEmpty() {
        return this.updateIndices.isEmpty() && this.clearIndices.isEmpty() && !this.hasLastGroup();
    }

    public byte[] updatesToByteArray() {
        if (this.updateArrayByte == null) {
            this.updateArrayByte = GroupBoundaries.indicesToByteArray(this.updateIndices);
        }
        return this.updateArrayByte;
    }

    public byte[] clearsToByteArray() {
        if (this.clearArrayByte == null) {
            this.clearArrayByte = GroupBoundaries.indicesToByteArray(this.clearIndices);
        }
        return this.clearArrayByte;
    }

    private static byte[] indicesToByteArray(TBitSet indices) {
        if (indices.isEmpty()) {
            return EmptyArrays.BYTE;
        }
        byte[] array = new byte[indices.numberOfSetBits()];
        int i2 = 0;
        PrimitiveIterator.OfInt ofInt = indices.iterator();
        while (ofInt.hasNext()) {
            int j2 = (Integer)ofInt.next();
            assert (j2 < 256);
            array[i2++] = (byte)j2;
        }
        return array;
    }

    public void materializeArrays() {
        if (this.updateArray == null) {
            this.updateArray = GroupBoundaries.indicesToShortArray(this.updateIndices);
            this.clearArray = GroupBoundaries.indicesToShortArray(this.clearIndices);
        }
    }

    private static short[] indicesToShortArray(TBitSet indices) {
        if (indices.isEmpty()) {
            return EmptyArrays.SHORT;
        }
        short[] array = new short[indices.numberOfSetBits()];
        GroupBoundaries.writeIndicesToArray(indices, array, 0);
        return array;
    }

    private static void writeIndicesToArray(TBitSet indices, short[] array, int offset) {
        int i2 = offset;
        PrimitiveIterator.OfInt ofInt = indices.iterator();
        while (ofInt.hasNext()) {
            int j2 = (Integer)ofInt.next();
            assert (j2 < 65536);
            array[i2++] = (short)j2;
        }
    }

    public TBitSet getUpdateIndices() {
        return this.updateIndices;
    }

    public TBitSet getClearIndices() {
        return this.clearIndices;
    }

    public boolean hasIndexUpdates() {
        return !this.updateIndices.isEmpty();
    }

    public boolean hasIndexClears() {
        return !this.clearIndices.isEmpty();
    }

    public boolean hasLastGroup() {
        return this.lastGroup != -1;
    }

    public void updateBitSets(TBitSet foreignUpdateIndices, TBitSet foreignClearIndices) {
        foreignUpdateIndices.union(this.updateIndices);
        foreignClearIndices.subtract(this.updateIndices);
        foreignClearIndices.union(this.clearIndices);
    }

    public int getLastGroup() {
        return this.lastGroup;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GroupBoundaries)) {
            return false;
        }
        GroupBoundaries o2 = (GroupBoundaries)obj;
        return Objects.equals(this.updateIndices, o2.updateIndices) && Objects.equals(this.clearIndices, o2.clearIndices) && this.lastGroup == o2.lastGroup;
    }

    public int hashCode() {
        return this.cachedHash;
    }

    public void applyToResultFactory(PreCalculatedResultFactory resultFactory, int index, boolean trackLastGroup) {
        if (this.hasIndexUpdates()) {
            resultFactory.updateIndices(this.updateIndices, index);
        }
        if (this.hasIndexClears()) {
            resultFactory.clearIndices(this.clearIndices);
        }
        if (trackLastGroup && this.hasLastGroup()) {
            resultFactory.setLastGroup(this.getLastGroup());
        }
    }

    @ExplodeLoop
    public void applyExploded(int[] array, int cgOffset, int lgOffset, int index, boolean trackLastGroup, boolean dontOverwriteLastGroup) {
        int i2;
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(this.clearArray);
        CompilerAsserts.partialEvaluationConstant(this.updateArray);
        CompilerAsserts.partialEvaluationConstant(this.lastGroup);
        for (i2 = 0; i2 < this.clearArray.length; ++i2) {
            array[cgOffset + Short.toUnsignedInt((short)this.clearArray[i2])] = -1;
        }
        for (i2 = 0; i2 < this.updateArray.length; ++i2) {
            array[cgOffset + Short.toUnsignedInt((short)this.updateArray[i2])] = index;
        }
        if (trackLastGroup && this.hasLastGroup() && (!dontOverwriteLastGroup || array[lgOffset] == -1)) {
            array[lgOffset] = this.getLastGroup();
        }
    }

    public void apply(int[] array, int cgOffset, int lgOffset, int index, boolean trackLastGroup) {
        int i2;
        for (i2 = 0; i2 < this.clearArray.length; ++i2) {
            array[cgOffset + Short.toUnsignedInt((short)this.clearArray[i2])] = -1;
        }
        for (i2 = 0; i2 < this.updateArray.length; ++i2) {
            array[cgOffset + Short.toUnsignedInt((short)this.updateArray[i2])] = index;
        }
        if (trackLastGroup && this.hasLastGroup()) {
            array[lgOffset] = this.getLastGroup();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasIndexUpdates()) {
            GroupBoundaries.appendBitSet(sb, this.updateIndices, false).append(")(");
            GroupBoundaries.appendBitSet(sb, this.updateIndices, true);
        }
        if (this.hasIndexClears()) {
            sb.append(" clr{");
            GroupBoundaries.appendBitSet(sb, this.clearIndices, false).append(")(");
            GroupBoundaries.appendBitSet(sb, this.clearIndices, true);
            sb.append("}");
        }
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary
    private static StringBuilder appendBitSet(StringBuilder sb, TBitSet gbBitSet, boolean entries) {
        boolean first = true;
        if (gbBitSet != null) {
            PrimitiveIterator.OfInt ofInt = gbBitSet.iterator();
            while (ofInt.hasNext()) {
                int i2 = (Integer)ofInt.next();
                if ((i2 & 1) != (entries ? 0 : 1)) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(Json.val(i2 / 2));
            }
        }
        return sb;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("updateEnter", GroupBoundaries.gbBitSetGroupEntriesToJsonArray(this.updateIndices)), Json.prop("updateExit", GroupBoundaries.gbBitSetGroupExitsToJsonArray(this.updateIndices)), Json.prop("clearEnter", GroupBoundaries.gbBitSetGroupEntriesToJsonArray(this.clearIndices)), Json.prop("clearExit", GroupBoundaries.gbBitSetGroupExitsToJsonArray(this.clearIndices)));
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray gbBitSetGroupEntriesToJsonArray(TBitSet gbArray) {
        return GroupBoundaries.gbBitSetGroupPartToJsonArray(gbArray, true);
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray gbBitSetGroupExitsToJsonArray(TBitSet gbArray) {
        return GroupBoundaries.gbBitSetGroupPartToJsonArray(gbArray, false);
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray gbBitSetGroupPartToJsonArray(TBitSet gbBitSet, boolean entries) {
        JsonArray array = Json.array(new JsonConvertible[0]);
        if (gbBitSet != null) {
            PrimitiveIterator.OfInt ofInt = gbBitSet.iterator();
            while (ofInt.hasNext()) {
                int i2 = (Integer)ofInt.next();
                if ((i2 & 1) != (entries ? 0 : 1)) continue;
                array.append(Json.val(i2 / 2));
            }
        }
        return array;
    }

    @CompilerDirectives.TruffleBoundary
    public JsonArray indexUpdateSourceSectionsToJson(RegexAST ast) {
        if (!this.hasIndexUpdates() || !ast.getOptions().isDumpAutomataWithSourceSections()) {
            return Json.array(new JsonConvertible[0]);
        }
        return RegexAST.sourceSectionsToJson(this.getUpdateIndices().stream().mapToObj(x2 -> ast.getSourceSections(ast.getGroupByBoundaryIndex(x2)).get(x2 & 1)));
    }
}

