/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSURLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class JSURLDecoder {
    private final boolean isSpecial;

    public JSURLDecoder(boolean isSpecial) {
        this.isSpecial = isSpecial;
    }

    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    public TruffleString decode(TruffleString string) {
        int strLen = Strings.length(string);
        TruffleStringBuilderUTF16 sb = null;
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        for (int k2 = 0; k2 < strLen; ++k2) {
            char c2 = Strings.charAt(string, k2);
            if (c2 != '%') {
                if (sb == null) continue;
                Strings.builderAppend(sb, c2);
                continue;
            }
            if (sb == null) {
                sb = JSURLEncoder.allocStringBuilder(string, k2, strLen);
            }
            k2 = this.decodeConvert(string, strLen, k2, sb, decoder);
        }
        return sb != null ? Strings.builderToString(sb) : string;
    }

    private int decodeConvert(TruffleString string, int strLen, int start, TruffleStringBuilderUTF16 buffer, CharsetDecoder decoder) {
        int k2 = start;
        if (k2 + 2 >= strLen) {
            throw Errors.createURIError("illegal escape sequence");
        }
        int hex1 = JSURLDecoder.getHexValue(Strings.charAt(string, k2 + 1));
        int hex2 = JSURLDecoder.getHexValue(Strings.charAt(string, k2 + 2));
        byte b2 = (byte)((hex1 << 4) + hex2);
        k2 += 2;
        if ((b2 & 0x80) == 0) {
            char c2 = (char)b2;
            if (!this.isReserved(c2)) {
                Strings.builderAppend(buffer, c2);
            } else {
                Strings.builderAppend(buffer, string, start, k2 + 1);
            }
        } else {
            k2 = this.decodeConvertIntl(string, strLen, k2, b2, buffer, decoder);
        }
        return k2;
    }

    private int decodeConvertIntl(TruffleString string, int strLen, int kParam, byte b2, TruffleStringBuilderUTF16 buffer, CharsetDecoder decoder) {
        int k2 = kParam;
        int n2 = JSURLDecoder.findN(b2);
        if (n2 == 1 || n2 > 4) {
            throw JSURLDecoder.invalidEncodingError();
        }
        byte[] octetsB = new byte[n2];
        octetsB[0] = b2;
        if (k2 + 3 * (n2 - 1) >= strLen) {
            throw JSURLDecoder.invalidEncodingError();
        }
        for (int j2 = 1; j2 < n2; ++j2) {
            int hex4;
            if (Strings.charAt(string, ++k2) != '%') {
                throw JSURLDecoder.invalidEncodingError();
            }
            int hex3 = JSURLDecoder.getHexValue(Strings.charAt(string, k2 + 1));
            byte b22 = (byte)((hex3 << 4) + (hex4 = JSURLDecoder.getHexValue(Strings.charAt(string, k2 + 2))));
            if ((b22 & 0xC0) != 128) {
                throw JSURLDecoder.invalidEncodingError();
            }
            k2 += 2;
            octetsB[j2] = b22;
        }
        ByteBuffer bb = ByteBuffer.wrap(octetsB);
        CharBuffer cb = CharBuffer.wrap(new char[2]);
        decoder.reset();
        cb.rewind();
        CoderResult coderResult = decoder.decode(bb, cb, true);
        if (coderResult.isError()) {
            throw JSURLDecoder.invalidEncodingError();
        }
        if (cb.position() == 1) {
            assert (!this.isReserved(cb.get(0)));
            Strings.builderAppend(buffer, cb.get(0));
        } else {
            Strings.builderAppend(buffer, cb.get(0));
            Strings.builderAppend(buffer, cb.get(1));
        }
        return k2;
    }

    private static JSException invalidEncodingError() {
        throw Errors.createURIError("invalid encoding");
    }

    private static int getHexValue(char digit) {
        int value = JSRuntime.valueInHex(digit);
        if (value < 0) {
            throw Errors.createURIError("decode: Illegal hex characters in escape (%) pattern");
        }
        return value;
    }

    private boolean isReserved(char c2) {
        if (this.isSpecial) {
            return JSURLEncoder.reservedURISet.get(c2);
        }
        return false;
    }

    private static int findN(byte b2) {
        if ((b2 & 0x40) == 0) {
            return 1;
        }
        if ((b2 & 0x20) == 0) {
            return 2;
        }
        if ((b2 & 0x10) == 0) {
            return 3;
        }
        if ((b2 & 8) == 0) {
            return 4;
        }
        if ((b2 & 4) == 0) {
            return 5;
        }
        if ((b2 & 2) == 0) {
            return 6;
        }
        if ((b2 & 1) == 0) {
            return 7;
        }
        return 8;
    }
}

