/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.temporal.CalendarMethodsRecordLookupNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarSlotValueWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.SnapshotOwnPropertiesNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalYearMonthFromFieldsNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class ToTemporalYearMonthNode
extends JavaScriptBaseNode {
    protected ToTemporalYearMonthNode() {
    }

    public abstract JSTemporalPlainYearMonthObject execute(Object var1, JSDynamicObject var2);

    @Specialization
    public JSTemporalPlainYearMonthObject toTemporalYearMonth(Object item, JSDynamicObject optionsParam, @Cached SnapshotOwnPropertiesNode snapshotOwnProperties, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedBranchProfile errorBranch, @Cached IsObjectNode isObjectNode, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalCalendarSlotValueWithISODefaultNode getCalendarSlotValueWithISODefault, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached(value="createYearMonthFromFields()") CalendarMethodsRecordLookupNode lookupYearMonthFromFields, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode) {
        JSDynamicObject options;
        JSDynamicObject jSDynamicObject = options = optionsParam == Undefined.instance ? optionsParam : snapshotOwnProperties.snapshot(optionsParam, Null.instance);
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = (JSDynamicObject)item;
            if (JSTemporalPlainYearMonth.isJSTemporalPlainYearMonth(itemObj)) {
                return (JSTemporalPlainYearMonthObject)itemObj;
            }
            Object calendar = getCalendarSlotValueWithISODefault.execute(item);
            Object fieldsMethod = lookupFields.execute(calendar);
            Object yearMonthFromFieldsMethod = lookupYearMonthFromFields.execute(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forFieldsAndYearMonthFromFields(calendar, fieldsMethod, yearMonthFromFieldsMethod);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, TemporalUtil.listMMCY);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getLanguage().getJSContext(), itemObj, fieldNames, TemporalUtil.listEmpty);
            return yearMonthFromFieldsNode.execute(calendarRec, fields, options);
        }
        if (item instanceof TruffleString) {
            TruffleString string = (TruffleString)item;
            JSTemporalDateTimeRecord result = TemporalUtil.parseTemporalYearMonthString(string);
            TruffleString calendar = result.getCalendar();
            if (calendar == null) {
                calendar = TemporalConstants.ISO8601;
            }
            if (!TemporalUtil.isBuiltinCalendar(calendar)) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorCalendarNotSupported();
            }
            TemporalUtil.toTemporalOverflow(options, getOptionNode);
            JSTemporalPlainYearMonthObject result2 = JSTemporalPlainYearMonth.create(this.getLanguage().getJSContext(), this.getRealm(), result.getYear(), result.getMonth(), calendar, result.getDay(), this, errorBranch);
            Object yearMonthFromFieldsMethod = lookupYearMonthFromFields.execute(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forYearMonthFromFields(calendar, yearMonthFromFieldsMethod);
            return yearMonthFromFieldsNode.execute(calendarRec, result2, Undefined.instance);
        }
        errorBranch.enter(this);
        throw Errors.createTypeErrorNotAString(item);
    }
}

