/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.function.ConstructorResultNodeGen;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public abstract class ConstructorResultNode
extends JavaScriptNode {
    @Node.Child
    @Executed
    protected JavaScriptNode bodyNode;
    @Node.Child
    private JavaScriptNode thisNode;
    private final boolean derived;

    protected ConstructorResultNode(boolean derived, JavaScriptNode bodyNode, JavaScriptNode thisNode) {
        this.bodyNode = bodyNode;
        this.derived = derived;
        this.thisNode = thisNode;
    }

    public static JavaScriptNode createDerived(JavaScriptNode bodyNode, JavaScriptNode thisNode) {
        return ConstructorResultNodeGen.create(true, bodyNode, thisNode);
    }

    @Specialization
    protected final Object constructorBodyReturnValue(VirtualFrame frame, Object result, @Cached IsObjectNode isObjectNode, @Cached InlinedConditionProfile isObject, @Cached InlinedConditionProfile isNotUndefined) {
        if (isObject.profile(this, isObjectNode.executeBoolean(result))) {
            return result;
        }
        if (this.derived && isNotUndefined.profile(this, result != Undefined.instance)) {
            return Null.instance;
        }
        Object thisObject = this.thisNode.execute(frame);
        assert (thisObject != JSFunction.CONSTRUCT);
        return thisObject;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return ConstructorResultNodeGen.create(this.derived, ConstructorResultNode.cloneUninitialized(this.bodyNode, materializedTags), ConstructorResultNode.cloneUninitialized(this.thisNode, materializedTags));
    }
}

