/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToIndexNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;

public abstract class JSToIndexNode
extends JavaScriptBaseNode {
    @NeverDefault
    public static JSToIndexNode create() {
        return JSToIndexNodeGen.create();
    }

    public abstract long executeLong(Object var1);

    @Specialization
    protected long doInt(int value, @Cached @Cached.Shared InlinedBranchProfile negativeIndexBranch) {
        if (value < 0) {
            negativeIndexBranch.enter(this);
            throw Errors.createRangeErrorIndexNegative(this);
        }
        return value;
    }

    @Specialization
    protected long doSafeInteger(SafeInteger value, @Cached @Cached.Shared InlinedBranchProfile negativeIndexBranch) {
        long longValue = value.longValue();
        if (longValue < 0L) {
            negativeIndexBranch.enter(this);
            throw Errors.createRangeErrorIndexNegative(this);
        }
        return longValue;
    }

    @Specialization
    protected long doDouble(double value, @Cached @Cached.Shared InlinedBranchProfile negativeIndexBranch, @Cached @Cached.Exclusive InlinedBranchProfile tooLargeIndexBranch) {
        long integerIndex = (long)value;
        if (integerIndex < 0L) {
            negativeIndexBranch.enter(this);
            throw Errors.createRangeErrorIndexNegative(this);
        }
        if (integerIndex > JSRuntime.MAX_SAFE_INTEGER_LONG) {
            tooLargeIndexBranch.enter(this);
            throw Errors.createRangeErrorIndexTooLarge(this);
        }
        return integerIndex;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static long doUndefined(Object value) {
        return 0L;
    }

    @Specialization
    protected static long doObject(Object value, @Cached JSToNumberNode toNumberNode, @Cached JSToIndexNode recursiveToIndexNode) {
        Number number = (Number)toNumberNode.execute(value);
        assert (number instanceof Integer || number instanceof Double);
        return recursiveToIndexNode.executeLong(number);
    }
}

