/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetIteratorDirectNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;

@ImportStatic(value={JSConfig.class})
@GenerateInline
@GenerateUncached
public abstract class GetIteratorDirectNode
extends JavaScriptBaseNode {
    public final IteratorRecord execute(Object iterator) {
        return this.execute(null, iterator);
    }

    public abstract IteratorRecord execute(Node var1, Object var2);

    @Specialization
    protected IteratorRecord get(JSObject obj, @Cached(value="createGetNextNode()", uncached="getNullNode()", inline=false) @Cached.Shared PropertyGetNode getNextMethodNode) {
        return GetIteratorDirectNode.getImpl(obj, getNextMethodNode);
    }

    @Specialization(guards={"isForeignObject(obj)"})
    protected IteratorRecord get(Object obj, @Cached(value="createGetNextNode()", uncached="getNullNode()", inline=false) @Cached.Shared PropertyGetNode getNextMethodNode, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
        JSRealm realm = JSRealm.get(this);
        TruffleLanguage.Env env = realm.getEnv();
        if (env.isHostObject(obj) && interop.isIterator(obj)) {
            JSDynamicObject prototype = realm.getForeignIteratorPrototype();
            Object nextMethod = getNextMethodNode == null ? JSObject.get(prototype, Strings.NEXT) : getNextMethodNode.getValue(prototype);
            return IteratorRecord.create(obj, nextMethod, false);
        }
        return GetIteratorDirectNode.getImpl(obj, getNextMethodNode);
    }

    private static IteratorRecord getImpl(Object obj, PropertyGetNode getNextMethodNode) {
        Object nextMethod = getNextMethodNode == null ? JSRuntime.get(obj, Strings.NEXT) : getNextMethodNode.getValue(obj);
        return IteratorRecord.create(obj, nextMethod, false);
    }

    @Fallback
    public IteratorRecord unsupported(Object obj) {
        throw Errors.createTypeErrorNotAnObject(obj, this);
    }

    @NeverDefault
    PropertyGetNode createGetNextNode() {
        return PropertyGetNode.create(Strings.NEXT, this.getJSContext());
    }

    @NeverDefault
    public static GetIteratorDirectNode create() {
        return GetIteratorDirectNodeGen.create();
    }
}

