/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.FunctionPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.ShadowRealmPrototypeBuiltinsFactory;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.ImportCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRealmBoundaryRootNode;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.builtins.JSShadowRealm;
import com.oracle.truffle.js.runtime.builtins.JSShadowRealmObject;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir.Module;

public final class ShadowRealmPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ShadowRealmPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new ShadowRealmPrototypeBuiltins();

    protected ShadowRealmPrototypeBuiltins() {
        super(JSShadowRealm.PROTOTYPE_NAME, ShadowRealmPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ShadowRealmPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return ShadowRealmPrototypeBuiltinsFactory.ShadowRealmEvaluateNodeGen.create(context, builtin, ShadowRealmPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return ShadowRealmPrototypeBuiltinsFactory.ShadowRealmImportValueNodeGen.create(context, builtin, ShadowRealmPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    private static JSFunctionData createWrappedFunctionImpl(JSContext context) {
        final class WrappedFunctionRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JSFunctionCallNode callWrappedTargetFunction;
            @Node.Child
            private GetWrappedValueNode getWrappedValue;
            final /* synthetic */ JSContext val$context;

            protected WrappedFunctionRootNode(JavaScriptLanguage javaScriptLanguage) {
                this.val$context = javaScriptLanguage;
                super(lang, null, null);
                this.callWrappedTargetFunction = JSFunctionCallNode.createCall();
                this.getWrappedValue = GetWrappedValueNode.create();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute(VirtualFrame frame) {
                Object[] args = frame.getArguments();
                JSFunctionObject.Wrapped functionObject = (JSFunctionObject.Wrapped)JSArguments.getFunctionObject(args);
                Object target = functionObject.getWrappedTargetFunction();
                assert (JSRuntime.isCallable(target)) : target;
                JSRealm callerRealm = functionObject.getRealm();
                JSRealm targetRealm = JSRuntime.getFunctionRealm(target, callerRealm);
                JSRealm mainRealm = JSRealm.getMain(this);
                JSRealm prevRealm = mainRealm.enterRealm(this, callerRealm);
                assert (this.getRealm() == callerRealm);
                try {
                    Object result;
                    int argCount = JSArguments.getUserArgumentCount(args);
                    Object[] wrappedArgs = JSArguments.createInitial(Undefined.instance, target, argCount);
                    for (int i2 = 0; i2 < argCount; ++i2) {
                        JSArguments.setUserArgument(wrappedArgs, i2, this.getWrappedValue.execute(this.val$context, targetRealm, JSArguments.getUserArgument(args, i2)));
                    }
                    Object wrappedThisArgument = this.getWrappedValue.execute(this.val$context, targetRealm, JSArguments.getThisObject(args));
                    JSArguments.setThisObject(wrappedArgs, wrappedThisArgument);
                    try {
                        JSRealm prevCallerRealm = mainRealm.enterRealm(this, targetRealm);
                        assert (prevCallerRealm == callerRealm);
                        try {
                            result = this.callWrappedTargetFunction.executeCall(wrappedArgs);
                        }
                        finally {
                            mainRealm.leaveRealm(this, callerRealm);
                        }
                    }
                    catch (AbstractTruffleException ex) {
                        throw this.wrapErrorFromShadowRealm(ex);
                    }
                    Object object = this.getWrappedValue.execute(this.val$context, callerRealm, result);
                    return object;
                }
                finally {
                    mainRealm.leaveRealm(this, prevRealm);
                }
            }

            @CompilerDirectives.TruffleBoundary
            private JSException wrapErrorFromShadowRealm(AbstractTruffleException ex) {
                Object message = ex.getMessage();
                if (message == null || ((String)message).isEmpty()) {
                    message = "Wrapped function call failed";
                } else {
                    String typeErrorPrefix = "TypeError: ";
                    String messagePrefix = "Wrapped function call failed with: ";
                    message = ((String)message).startsWith(typeErrorPrefix) && ((String)message).startsWith(messagePrefix, typeErrorPrefix.length()) ? ((String)message).substring(typeErrorPrefix.length()) : messagePrefix + (String)message;
                }
                return Errors.createTypeError((String)message, ex, this);
            }
        }
        return JSFunctionData.createCallOnly(context, new WrappedFunctionRootNode(context.getLanguage(), context).getCallTarget(), 0, Strings.EMPTY_STRING);
    }

    public static enum ShadowRealmPrototype implements BuiltinEnum<ShadowRealmPrototype>
    {
        evaluate(1),
        importValue(2);

        private final int length;

        private ShadowRealmPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={JSShadowRealm.class})
    public static abstract class ShadowRealmEvaluateNode
    extends JSBuiltinNode {
        public ShadowRealmEvaluateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object evaluate(JSShadowRealmObject thisObj, TruffleString sourceText, @Cached IndirectCallNode callNode, @Cached GetWrappedValueNode getWrappedValue) {
            Object result;
            JSRealm callerRealm = this.getRealm();
            JSRealm evalRealm = thisObj.getShadowRealm();
            this.getContext().checkEvalAllowed();
            ScriptNode script = this.parseScript(Strings.toJavaString(sourceText));
            try {
                JSRealm mainRealm = JSRealm.getMain(this);
                JSRealm prevRealm = mainRealm.enterRealm(this, evalRealm);
                try {
                    result = script.runEval(callNode, evalRealm);
                }
                finally {
                    mainRealm.leaveRealm(this, prevRealm);
                }
            }
            catch (AbstractTruffleException ex) {
                throw this.wrapErrorFromShadowRealm(ex);
            }
            return getWrappedValue.execute(this.getContext(), callerRealm, result);
        }

        @CompilerDirectives.TruffleBoundary
        private JSException wrapErrorFromShadowRealm(AbstractTruffleException ex) {
            return Errors.createTypeError("ShadowRealm.prototype.evaluate failed with: " + ex.getMessage(), ex, this);
        }

        private ScriptNode parseScript(String sourceCode) {
            CompilerAsserts.neverPartOfCompilation();
            assert (this.getContext().getLanguageOptions().allowEval());
            Source source = Source.newBuilder("js", sourceCode, "<eval>").build();
            return this.getContext().getEvaluator().parseEval(this.getContext(), this, source, null);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isString(sourceText)"})
        protected Object invalidSourceText(JSShadowRealmObject thisObj, Object sourceText) {
            throw Errors.createTypeErrorNotAString(sourceText);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isJSShadowRealm(thisObj)"})
        protected Object invalidReceiver(Object thisObj, Object sourceText) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    @ImportStatic(value={JSShadowRealm.class})
    public static abstract class ShadowRealmImportValueNode
    extends JSBuiltinNode {
        protected static final HiddenKey EXPORT_NAME_STRING = new HiddenKey("ExportNameString");

        public ShadowRealmImportValueNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object importValue(JSShadowRealmObject thisObj, Object specifier, Object exportName, @Cached JSToStringNode toStringNode, @Cached(value="create(getContext())") NewPromiseCapabilityNode newPromiseCapabilityNode, @Cached(value="create(getContext())") PerformPromiseThenNode performPromiseThenNode, @Cached(value="createSetHidden(EXPORT_NAME_STRING, getContext())") PropertySetNode setExportNameStringNode, @Cached(value="create(getContext())") ImportCallNode importNode) {
            TruffleString specifierString = toStringNode.executeString(specifier);
            if (!JSGuards.isString(exportName)) {
                throw Errors.createTypeErrorNotAString(exportName);
            }
            TruffleString exportNameString = (TruffleString)exportName;
            JSRealm callerRealm = this.getRealm();
            JSRealm evalRealm = thisObj.getShadowRealm();
            PromiseCapabilityRecord innerCapability = newPromiseCapabilityNode.executeDefault();
            JSRealm mainRealm = JSRealm.getMain(this);
            JSRealm prevRealm = mainRealm.enterRealm(this, evalRealm);
            try {
                Source callerSource = Strings.startsWith(specifierString, Strings.DOT_SLASH) || Strings.startsWith(specifierString, Strings.DOT_DOT_SLASH) ? ShadowRealmImportValueNode.retrieveCallerSource() : null;
                ScriptOrModule activeScriptOrModule = callerSource == null ? null : new ScriptOrModule(this.getContext(), callerSource);
                importNode.hostImportModuleDynamically(activeScriptOrModule, Module.ModuleRequest.create(specifierString), innerCapability);
            }
            finally {
                mainRealm.leaveRealm(this, prevRealm);
            }
            JSFunctionData functionData = this.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ExportGetter, ShadowRealmImportValueNode::createExportGetterImpl);
            JSFunctionObject onFulfilled = JSFunction.create(callerRealm, functionData);
            setExportNameStringNode.setValue(onFulfilled, exportNameString);
            PromiseCapabilityRecord promiseCapability = newPromiseCapabilityNode.executeDefault();
            return performPromiseThenNode.execute((JSPromiseObject)innerCapability.getPromise(), onFulfilled, callerRealm.getThrowTypeErrorFunction(), promiseCapability);
        }

        private static JSFunctionData createExportGetterImpl(JSContext context) {
            final class ExportGetterRootNode
            extends JavaScriptRealmBoundaryRootNode {
                @Node.Child
                private JavaScriptNode argumentNode;
                @Node.Child
                private PropertyGetNode getExportNameString;
                @Node.Child
                private JSHasPropertyNode hasOwnProperty;
                @Node.Child
                private ReadElementNode getExport;
                @Node.Child
                private GetWrappedValueNode getWrappedValue;
                final /* synthetic */ JSContext val$context;

                protected ExportGetterRootNode(JavaScriptLanguage javaScriptLanguage) {
                    this.val$context = javaScriptLanguage;
                    super(lang);
                    this.argumentNode = AccessIndexedArgumentNode.create(0);
                    this.getExportNameString = PropertyGetNode.createGetHidden(EXPORT_NAME_STRING, this.val$context);
                    this.hasOwnProperty = JSHasPropertyNode.create(true);
                    this.getExport = ReadElementNode.create(this.val$context);
                    this.getWrappedValue = GetWrappedValueNode.create();
                }

                @Override
                public Object executeInRealm(VirtualFrame frame) {
                    JSFunctionObject functionObject = JSFrameUtil.getFunctionObject(frame);
                    TruffleString exportNameString = (TruffleString)this.getExportNameString.getValue(functionObject);
                    Object exports = this.argumentNode.execute(frame);
                    JSRealm callerRealm = functionObject.getRealm();
                    assert (this.getRealm() == callerRealm);
                    if (!this.hasOwnProperty.executeBoolean(exports, exportNameString)) {
                        throw Errors.createTypeErrorCannotGetProperty(exportNameString, exports, false, this);
                    }
                    Object value = this.getExport.executeWithTargetAndIndex(exports, exportNameString);
                    return this.getWrappedValue.execute(this.val$context, callerRealm, value);
                }
            }
            return JSFunctionData.createCallOnly(context, new ExportGetterRootNode(context.getLanguage(), context).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isJSShadowRealm(thisObj)"})
        protected Object invalidReceiver(Object thisObj, Object specifier, Object exportName) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }

        @CompilerDirectives.TruffleBoundary
        private static Source retrieveCallerSource() {
            Source callerSource = Truffle.getRuntime().iterateFrames(frameInstance -> {
                if (!(frameInstance.getCallTarget() instanceof RootCallTarget)) {
                    return null;
                }
                RootNode root = ((RootCallTarget)frameInstance.getCallTarget()).getRootNode();
                if (root.isInternal()) {
                    return null;
                }
                SourceSection sourceSection = root.getSourceSection();
                if (sourceSection != null && sourceSection.isAvailable()) {
                    return sourceSection.getSource();
                }
                return null;
            });
            return callerSource;
        }
    }

    @ImportStatic(value={JSFunction.class})
    static abstract class GetWrappedValueNode
    extends JavaScriptBaseNode {
        GetWrappedValueNode() {
        }

        abstract Object execute(JSContext var1, JSRealm var2, Object var3);

        @Specialization(guards={"isCallable.executeBoolean(value)"})
        protected final Object objectCallable(JSContext context, JSRealm callerRealm, Object value, @Cached @Cached.Shared IsCallableNode isCallable, @Cached(value="create(context)") FunctionPrototypeBuiltins.CopyFunctionNameAndLengthNode copyNameAndLengthNode) {
            CompilerAsserts.partialEvaluationConstant(context);
            JSFunctionData wrappedFunctionCall = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.OrdinaryWrappedFunctionCall, ShadowRealmPrototypeBuiltins::createWrappedFunctionImpl);
            JSFunctionObject wrapped = JSFunction.createWrapped(context, callerRealm, wrappedFunctionCall, value);
            try {
                copyNameAndLengthNode.execute(wrapped, value, Strings.EMPTY_STRING, 0);
            }
            catch (AbstractTruffleException ex) {
                throw this.toTypeError(ex, callerRealm);
            }
            return wrapped;
        }

        @Specialization(guards={"isObject.executeBoolean(value)", "!isCallable.executeBoolean(value)"})
        protected final Object objectNotCallable(JSContext context, JSRealm callerRealm, Object value, @Cached @Cached.Shared IsObjectNode isObject, @Cached @Cached.Shared IsCallableNode isCallable) {
            throw Errors.createTypeErrorNotAFunction(value, this);
        }

        @Specialization(guards={"!isObject.executeBoolean(value)"})
        protected static Object primitive(JSContext context, JSRealm callerRealm, Object value, @Cached @Cached.Shared IsObjectNode isObject) {
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        private AbstractTruffleException toTypeError(AbstractTruffleException exception, JSRealm callerRealm) {
            JSException jsException;
            if (exception instanceof JSException && (jsException = (JSException)exception).getErrorType() == JSErrorType.TypeError && jsException.getRealm() == callerRealm) {
                return jsException;
            }
            return Errors.createTypeError(exception, (Node)this);
        }

        @NeverDefault
        public static GetWrappedValueNode create() {
            return ShadowRealmPrototypeBuiltinsFactory.GetWrappedValueNodeGen.create();
        }
    }
}

